---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストのコミットの表示を理解する方法。
title: コミット
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

コミットは、ソースブランチのコードの変更を[リポジトリ](../repository/_index.md)に記録して送信します。詳しくは、[リポジトリへの変更の記録](https://git-scm.com/book/en/v2/Git-Basics-Recording-Changes-to-the-Repository)をご覧ください。

## コマンドラインを使用して変更をコミットする {#commit-changes-using-the-command-line}

コマンドラインを使用する場合は、[`git commit`](../../../topics/git/commands.md#git-commit)を使用します。変更をプッシュする前に、複数のコミットを追加できます。

- コミットメッセージ:

  コミットメッセージは、何が変更されたのか、その理由を識別します。変更を明確にするために、説明的なメッセージを使用してください。GitLabでは、次のいずれかのアクションを実行するために、コミットメッセージにキーワードを追加できます:

  - GitLab CI/CDパイプラインをトリガーする:

    プロジェクトが[GitLab CI/CD](../../../ci/_index.md)で構成されている場合、コミットごとではなく、プッシュごとにパイプラインをトリガーします。

  - パイプラインをスキップ:

    [`ci skip`](../../../ci/pipelines/_index.md#skip-a-pipeline)というキーワードをコミットメッセージに追加して、GitLab CI/CDがパイプラインをスキップするようにします。

  - クロスリンクイシューとマージリクエスト:

    [クロスリンク](../issues/crosslinking_issues.md#from-commit-messages)を使用して、ワークフローの関連部分を追跡します。コミットメッセージでイシューまたはマージリクエストについて言及すると、それぞれのスレッドに表示されます。

- コミットをチェリーピックする:

  GitLabでは、UIから[コミットをチェリーピックする](cherry_pick_changes.md#cherry-pick-a-single-commit)ことができます。

- コミットをリバートする:

  UIから選択したブランチに[コミットを元に戻す](revert_changes.md#revert-a-commit)。

- コミットに署名する:

  [コミットに署名](../repository/signed_commits/_index.md)することで、セキュリティを強化します。

詳細については、[ステージ、コミット、およびプッシュの変更](../../../topics/git/commit.md)を参照してください。

## マージリクエストのコミット {#merge-request-commits}

各マージリクエストには、マージリクエストが作成された後にソースブランチに加えられたコミットの履歴があります。

これらのコミットは、マージリクエストの**コミット**タブに表示されます。このタブから、コミットメッセージを確認し、[変更をチェリーピックする](cherry_pick_changes.md)必要がある場合にコミットのSHAをコピーできます。

### マージリクエストでコミットをスカッシュする {#view-commits-in-a-merge-request}

マージリクエストに含まれるコミットを確認するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを選択します。
1. マージリクエスト内のコミットのリストを先頭に表示するには、**コミット**を選択します。コミットの詳細については、任意のコミットで**コミットの説明の切り替え**({{< icon name="ellipsis_h" >}})を選択してください。
1. コミットの変更を表示するには、コミットリンクのタイトルを選択します。
1. マージリクエスト内の他のコミットを表示するには、次のいずれかの操作を行います:

   - **前ページ**または**次へ**を選択します。
   - キーボードショートカットを使用します: <kbd>X</kbd> (コミットを前に戻す) および<kbd>C</kbd> (コミットを次に進む)を選択します。

マージリクエストが以前のマージリクエストに基づいてビルドされている場合は、[コンテキスト用により多くのコミットを含める](#show-commits-from-previous-merge-requests)必要がある場合があります。

### 以前のマージリクエストからコミットを表示する {#show-commits-from-previous-merge-requests}

マージリクエストをレビューする場合、レビューしているコミットを理解するために、以前のコミットからの情報が必要になる場合があります。別のマージリクエストの場合、より多くのコンテキストが必要になることがあります:

- 現在のマージリクエストが変更しないファイルが変更されたため、これらのファイルは現在のマージリクエストの差分に表示されません。
- 現在のマージリクエストで変更しているファイルが変更され、作業の進捗状況を確認する必要がある。

コンテキストを増やすために、以前にマージされたコミットをマージリクエストに追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを選択します。
1. **コミット**を選択します。
1. コミットのリストの最後にスクロールし、**以前にマージしたコミットを追加**を選択します。
1. 追加するコミットを選択します。
1. **変更を保存**を選択します。

以前にマージされたコミットは、[API](../../../api/merge_request_context_commits.md)では**Context Commits**（コンテキストコミット）と呼ばれます。

### コミットにコメントを追加する {#add-a-comment-to-a-commit}

{{< alert type="warning" >}}

この方法で作成されたスレッドは、強制プッシュ後にコミットIDが変更されると失われます。

{{< /alert >}}

特定のコミットにディスカッションを追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. コミットの下にある**コメント**フィールドに、コメントを入力します。
1. スタンドアロンコメントまたはスレッドとしてコメントを保存します:
   - コメントを追加するには、**コメント**を選択します。
   - スレッドを開始するには、下向き矢印({{< icon name="chevron-down" >}})を選択し、**スレッドを開始します。**を選択します。

### コミット間の差分を表示する {#view-diffs-between-commits}

以前にマージされたコミット間の変更を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを選択します。
1. **変更**を選択します。
1. **比較**({{< icon name="file-tree" >}})で、比較するコミットを選択します:

   ![以前にマージされたコミット](img/previously_merged_commits_v16_0.png)

コンテキスト用に以前にマージされたコミットを追加するように選択した場合、これらのコミットもリストに表示されます。

### 変更を導入したマージリクエストを見つける {#find-the-merge-request-that-introduced-a-change}

コミットの詳細ページを表示すると、GitLabはそのコミットを含む1つまたは複数のマージリクエストにリンクします。

この動作は、マージリクエストの最新バージョンにあるコミットにのみ適用されます。コミットがマージリクエストにあり、そのマージリクエストからリベースされた場合、そのコミットはリンクされません。
