---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token LinkedIn client ID'
---

## Description

The response body contains content that matches the pattern of a LinkedIn Client ID was identified. Client IDs are used in combination with a client secret. A malicious actor with access to this ID can impersonate the client application if they also have access to the client secret.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). Client IDs do not need to be revoked or regenerated. For more information, please see [LinkedIn's documentation on API access](https://learn.microsoft.com/en-us/linkedin/learning/getting-started/request-access).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.68 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
