# frozen_string_literal: true

module API
  module Entities
    class WikiPageBasic < Grape::Entity
      expose :format, documentation: { type: 'String', example: 'markdown' }
      expose :slug, documentation: { type: 'String', example: 'deploy' }
      expose :title, documentation: { type: 'String', example: 'deploy' }

      expose :wiki_page_meta_id, documentation: { type: 'Integer', example: { wiki_page_meta_id: 123 } } do |wiki_page|
        wiki_page.find_or_create_meta.id
      end
    end
  end
end
