/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public final class VersionUtil {
    static final String SR_VERSION_PROPERTIES = VersionUtil.class.getName() + ".properties";
    static final String MP_POM_PROPERTIES = "/META-INF/maven/org.eclipse.microprofile.openapi/microprofile-openapi-api/pom.properties";
    static final String MP_VERSION = ModelUtil.supply(() -> VersionUtil.loadProperty(VersionUtil.class.getResource(SR_VERSION_PROPERTIES), "microprofile.openapi.version").orElseGet(() -> VersionUtil.loadProperty(OpenAPI.class.getResource(MP_POM_PROPERTIES), "version").orElseThrow(() -> new OpenApiRuntimeException("Unable to determine MicroProfile OpenAPI version"))));
    static final String[] MP_VERSION_COMPONENTS = ModelUtil.supply(() -> {
        int suffix = MP_VERSION.indexOf(45);
        return (suffix > -1 ? MP_VERSION.substring(0, suffix) : MP_VERSION).split("\\.");
    });

    private VersionUtil() {
    }

    static Optional<String> loadProperty(URL source, String key) {
        if (source != null) {
            Optional<String> optional;
            block9: {
                InputStream properties = source.openStream();
                try {
                    Properties p = new Properties();
                    p.load(properties);
                    optional = Optional.ofNullable(p.getProperty(key));
                    if (properties == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (properties != null) {
                            try {
                                properties.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                properties.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public static int compareMicroProfileVersion(String checkVersion) {
        int cv;
        int mp;
        String[] checkComponents = checkVersion.split("\\.");
        int max = Math.max(MP_VERSION_COMPONENTS.length, checkComponents.length);
        int result = 0;
        for (int i = 0; i < max && (result = Integer.compare(mp = VersionUtil.component(MP_VERSION_COMPONENTS, i), cv = VersionUtil.component(checkComponents, i))) == 0; ++i) {
        }
        return result;
    }

    static int component(String[] components, int offset) {
        return offset < components.length ? Integer.parseInt(components[offset]) : 0;
    }
}

