/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/InitializerCallReplacer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "replacement", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "initializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitCall", "expression", "ir.backend.common"})
public final class InitializerCallReplacer
extends IrElementTransformerVoid {
    @NotNull
    private final IrExpression replacement;
    @Nullable
    private IrCall initializerCall;

    public InitializerCallReplacer(@NotNull IrExpression replacement) {
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        this.replacement = replacement;
    }

    @Nullable
    public final IrCall getInitializerCall() {
        return this.initializerCall;
    }

    public final void setInitializerCall(@Nullable IrCall irCall) {
        this.initializerCall = irCall;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.initializerCall != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Multiple initializer calls found. First: ");
            IrCall irCall = this.initializerCall;
            Intrinsics.checkNotNull(irCall);
            throw new IllegalStateException(stringBuilder.append(RenderIrElementKt.render$default(irCall, null, 1, null)).append("\nSecond: ").append(RenderIrElementKt.render$default(expression2, null, 1, null)).toString());
        }
        this.initializerCall = expression2;
        return this.replacement;
    }
}

