/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.hebrew;

import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import java.util.Collections;

public class HebrewTreeNormalizer
extends BobChrisTreeNormalizer {
    private static final long serialVersionUID = -3129547164200725933L;
    private final Filter<Tree> hebrewEmptyFilter = new HebrewEmptyFilter();

    public HebrewTreeNormalizer() {
        super(new HebrewTreebankLanguagePack());
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        for (tree = tree.prune(this.hebrewEmptyFilter, tf).spliceOut(this.aOverAFilter, tf); tree != null && (tree.value() == null || tree.value().equals("")) && tree.numChildren() <= 1; tree = tree.firstChild()) {
        }
        if (tree != null && !tree.value().equals(this.tlp.startSymbol())) {
            tree = tf.newTreeNode(this.tlp.startSymbol(), Collections.singletonList(tree));
        }
        return tree;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HebrewEmptyFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = -7256461296718287280L;

        @Override
        public boolean accept(Tree t) {
            return !t.isPreTerminal() || !t.value().equals("-NONE-");
        }
    }
}

