/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.processor;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.neuralsearch.highlight.batch.processor.SemanticHighlightingProcessor;
import org.opensearch.neuralsearch.highlight.utils.HighlightExtractorUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.ProcessorGenerationContext;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.SystemGeneratedProcessor;

public class SemanticHighlightingFactory
implements SystemGeneratedProcessor.SystemGeneratedFactory<SearchResponseProcessor> {
    @Generated
    private static final Logger log = LogManager.getLogger(SemanticHighlightingFactory.class);
    private final MLCommonsClientAccessor mlClientAccessor;

    public SemanticHighlightingFactory(MLCommonsClientAccessor mlClientAccessor) {
        this.mlClientAccessor = mlClientAccessor;
    }

    public boolean shouldGenerate(ProcessorGenerationContext context) {
        SearchRequest request = context.searchRequest();
        if (request == null || request.source() == null) {
            return false;
        }
        SearchSourceBuilder source = request.source();
        HighlightBuilder highlightBuilder = source.highlighter();
        if (highlightBuilder == null || highlightBuilder.fields() == null) {
            return false;
        }
        String semanticField = HighlightExtractorUtils.extractSemanticField(highlightBuilder);
        return semanticField != null;
    }

    public SearchResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String processorTag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
        return new SemanticHighlightingProcessor(ignoreFailure, this.mlClientAccessor);
    }
}

