/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.proxy.DruidDriver;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyImpl;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcConnectionStat;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcResultSetStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManagerMBean;
import com.alibaba.druid.stat.JdbcStatementStat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class JdbcStatManager
implements JdbcStatManagerMBean {
    private final AtomicLong sqlIdSeed = new AtomicLong(1000L);
    private static final JdbcStatManager instance = new JdbcStatManager();
    private final JdbcConnectionStat connectionStat = new JdbcConnectionStat();
    private final JdbcResultSetStat resultSetStat = new JdbcResultSetStat();
    private final JdbcStatementStat statementStat = new JdbcStatementStat();
    private final AtomicLong resetCount = new AtomicLong();
    public final ThreadLocal<JdbcStatContext> contextLocal = new ThreadLocal();
    private static CompositeType COMPOSITE_TYPE = null;

    private JdbcStatManager() {
    }

    public JdbcStatContext getStatContext() {
        return this.contextLocal.get();
    }

    public void setStatContext(JdbcStatContext context) {
        this.contextLocal.set(context);
    }

    public JdbcStatContext createStatContext() {
        return new JdbcStatContext();
    }

    public long generateSqlId() {
        return this.sqlIdSeed.incrementAndGet();
    }

    public static JdbcStatManager getInstance() {
        return instance;
    }

    public JdbcStatementStat getStatementStat() {
        return this.statementStat;
    }

    public JdbcResultSetStat getResultSetStat() {
        return this.resultSetStat;
    }

    public JdbcConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public static CompositeType getDataSourceCompositeType() throws JMException {
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, new ArrayType(SimpleType.STRING, false), SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, new ArrayType(SimpleType.LONG, true), new ArrayType(SimpleType.LONG, true)};
        String[] indexNames = new String[]{"ID", "URL", "Name", "FilterClasses", "CreatedTime", "RawUrl", "RawDriverClassName", "RawDriverMajorVersion", "RawDriverMinorVersion", "Properties", "ConnectionActiveCount", "ConnectionActiveCountMax", "ConnectionCloseCount", "ConnectionCommitCount", "ConnectionRollbackCount", "ConnectionConnectLastTime", "ConnectionConnectErrorCount", "ConnectionConnectErrorLastTime", "ConnectionConnectErrorLastMessage", "ConnectionConnectErrorLastStackTrace", "StatementCreateCount", "StatementPrepareCount", "StatementPreCallCount", "StatementExecuteCount", "StatementRunningCount", "StatementConcurrentMax", "StatementCloseCount", "StatementErrorCount", "StatementLastErrorTime", "StatementLastErrorMessage", "StatementLastErrorStackTrace", "StatementExecuteMillisTotal", "ConnectionConnectingCount", "StatementExecuteLastTime", "ResultSetCloseCount", "ResultSetOpenCount", "ResultSetOpenningCount", "ResultSetOpenningMax", "ResultSetFetchRowCount", "ResultSetLastOpenTime", "ResultSetErrorCount", "ResultSetOpenningMillisTotal", "ResultSetLastErrorTime", "ResultSetLastErrorMessage", "ResultSetLastErrorStackTrace", "ConnectionConnectCount", "ConnectionErrorLastMessage", "ConnectionErrorLastStackTrace", "ConnectionConnectMillisTotal", "ConnectionConnectingCountMax", "ConnectionConnectMillisMax", "ConnectionErrorLastTime", "ConnectionAliveMillisMax", "ConnectionAliveMillisMin", "ConnectionHistogram", "StatementHistogram"};
        COMPOSITE_TYPE = new CompositeType("DataSourceStatistic", "DataSource Statistic", indexNames, indexNames, indexTypes);
        return COMPOSITE_TYPE;
    }

    @Override
    public TabularData getDataSourceList() throws JMException {
        CompositeType rowType = JdbcStatManager.getDataSourceCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("DataSourceStat", "DataSourceStat", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        Object dataSources = DruidDriver.getProxyDataSources();
        for (DataSourceProxy dataSource : dataSources.values()) {
            data.put(((DataSourceProxyImpl)dataSource).getCompositeData());
        }
        dataSources = DruidDataSourceStatManager.getDruidDataSourceInstances();
        Iterator<Object> i$ = dataSources.iterator();
        while (i$.hasNext()) {
            DataSourceProxy dataSource;
            dataSource = (DruidDataSource)i$.next();
            data.put(((DruidAbstractDataSource)dataSource).getCompositeData());
        }
        return data;
    }

    @Override
    public TabularData getSqlList() throws JMException {
        Map<String, Object> map;
        Map<String, JdbcSqlStat> statMap;
        JdbcDataSourceStat druidDataSourceStat;
        CompositeType rowType = JdbcSqlStat.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("SqlListStatistic", "SqlListStatistic", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        JdbcDataSourceStat globalStat = JdbcDataSourceStat.getGlobal();
        if (globalStat != null) {
            Map<String, JdbcSqlStat> statMap2 = globalStat.getSqlStatMap();
            for (Map.Entry<String, JdbcSqlStat> entry : statMap2.entrySet()) {
                if (entry.getValue().getExecuteCount() == 0L && entry.getValue().getRunningCount() == 0L) continue;
                Map<String, Object> map2 = entry.getValue().getData();
                map2.put("URL", globalStat.getUrl());
                data.put(new CompositeDataSupport(JdbcSqlStat.getCompositeType(), map2));
            }
        }
        for (DataSourceProxyImpl dataSourceProxyImpl : DruidDriver.getProxyDataSources().values()) {
            druidDataSourceStat = dataSourceProxyImpl.getDataSourceStat();
            if (druidDataSourceStat == globalStat) continue;
            statMap = druidDataSourceStat.getSqlStatMap();
            for (Map.Entry<String, JdbcSqlStat> entry : statMap.entrySet()) {
                if (entry.getValue().getExecuteCount() == 0L && entry.getValue().getRunningCount() == 0L) continue;
                map = entry.getValue().getData();
                map.put("URL", dataSourceProxyImpl.getUrl());
                data.put(new CompositeDataSupport(JdbcSqlStat.getCompositeType(), map));
            }
        }
        for (DruidDataSource druidDataSource : DruidDataSourceStatManager.getDruidDataSourceInstances()) {
            druidDataSourceStat = druidDataSource.getDataSourceStat();
            if (druidDataSourceStat == globalStat) continue;
            statMap = druidDataSourceStat.getSqlStatMap();
            for (Map.Entry<String, JdbcSqlStat> entry : statMap.entrySet()) {
                if (entry.getValue().getExecuteCount() == 0L && entry.getValue().getRunningCount() == 0L) continue;
                map = entry.getValue().getData();
                map.put("URL", druidDataSource.getUrl());
                data.put(new CompositeDataSupport(JdbcSqlStat.getCompositeType(), map));
            }
        }
        return data;
    }

    @Override
    public TabularData getConnectionList() throws JMException {
        ConcurrentMap<Long, JdbcConnectionStat.Entry> connections;
        JdbcDataSourceStat dataSourceStat;
        CompositeType rowType = JdbcConnectionStat.Entry.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("ConnectionList", "ConnectionList", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        ConcurrentMap<String, DataSourceProxyImpl> dataSources = DruidDriver.getProxyDataSources();
        for (DataSourceProxyImpl dataSource : dataSources.values()) {
            dataSourceStat = dataSource.getDataSourceStat();
            connections = dataSourceStat.getConnections();
            for (Map.Entry entry : connections.entrySet()) {
                data.put(((JdbcConnectionStat.Entry)entry.getValue()).getCompositeData());
            }
        }
        for (DruidDataSource instance : DruidDataSourceStatManager.getDruidDataSourceInstances()) {
            dataSourceStat = instance.getDataSourceStat();
            connections = dataSourceStat.getConnections();
            for (Map.Entry entry : connections.entrySet()) {
                data.put(((JdbcConnectionStat.Entry)entry.getValue()).getCompositeData());
            }
        }
        return data;
    }

    @Override
    public void reset() {
        this.resetCount.incrementAndGet();
        this.connectionStat.reset();
        this.statementStat.reset();
        this.resultSetStat.reset();
        ConcurrentMap<String, DataSourceProxyImpl> dataSources = DruidDriver.getProxyDataSources();
        for (DataSourceProxyImpl dataSource : dataSources.values()) {
            dataSource.getDataSourceStat().reset();
        }
        for (DruidDataSource instance : DruidDataSourceStatManager.getDruidDataSourceInstances()) {
            instance.getDataSourceStat().reset();
        }
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }
}

