/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.annotation.MLAlgoOutput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.MLOutputType;

@MLAlgoOutput(value=MLOutputType.ML_TASK_OUTPUT)
public class MLTaskOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.ML_TASK_OUTPUT;
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    public static final String RESPONSE_FIELD = "response";
    String taskId;
    String status;
    Map<String, Object> response;

    public MLTaskOutput(String taskId, String status, Map<String, Object> response) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.response = response;
    }

    public MLTaskOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
        if (in.readBoolean()) {
            this.response = in.readMap(s -> s.readString(), s -> s.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
        if (this.response != null) {
            out.writeBoolean(true);
            out.writeMap(this.response, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD, this.status);
        }
        if (this.response != null) {
            builder.field(RESPONSE_FIELD, this.response);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Generated
    public static MLTaskOutputBuilder builder() {
        return new MLTaskOutputBuilder();
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, Object> getResponse() {
        return this.response;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setResponse(Map<String, Object> response) {
        this.response = response;
    }

    @Generated
    public String toString() {
        return "MLTaskOutput(taskId=" + this.getTaskId() + ", status=" + this.getStatus() + ", response=" + String.valueOf(this.getResponse()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLTaskOutput)) {
            return false;
        }
        MLTaskOutput other = (MLTaskOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, Object> this$response = this.getResponse();
        Map<String, Object> other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLTaskOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, Object> $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        return result;
    }

    @Generated
    public static class MLTaskOutputBuilder {
        @Generated
        private String taskId;
        @Generated
        private String status;
        @Generated
        private Map<String, Object> response;

        @Generated
        MLTaskOutputBuilder() {
        }

        @Generated
        public MLTaskOutputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLTaskOutputBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public MLTaskOutputBuilder response(Map<String, Object> response) {
            this.response = response;
            return this;
        }

        @Generated
        public MLTaskOutput build() {
            return new MLTaskOutput(this.taskId, this.status, this.response);
        }

        @Generated
        public String toString() {
            return "MLTaskOutput.MLTaskOutputBuilder(taskId=" + this.taskId + ", status=" + this.status + ", response=" + String.valueOf(this.response) + ")";
        }
    }
}

