/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartVAxis
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartVAxis() {
        super(false, CommandChartVAxis.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartVAxis.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "AXIS", "(v2?-axis)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "TITLE", "\"([^\"]+)\"")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(2, "RANGE", "(-?[0-9.]+)\\s*-->\\s*(-?[0-9.]+)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "LABELS", "\\[([^\\]]+)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("ticks"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "TICKS", "\\[(.*)\\]"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("spacing"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "SPACING", "([0-9.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "LABELTOP", "(label-top)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "GRID", "(grid)")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String axisType = arg.get("AXIS", 0);
        String title = arg.getLazzy("TITLE", 0);
        String minStr = arg.getLazzy("RANGE", 0);
        String maxStr = arg.getLazzy("RANGE", 1);
        String labelsStr = arg.getLazzy("LABELS", 0);
        String ticksStr = arg.getLazzy("TICKS", 0);
        String spacingStr = arg.getLazzy("SPACING", 0);
        String labelTopStr = arg.getLazzy("LABELTOP", 0);
        String gridStr = arg.getLazzy("GRID", 0);
        if (labelsStr != null) {
            List<String> labels = this.parseLabels(labelsStr);
            return diagram.setYAxisLabels(labels);
        }
        Double min = null;
        Double max = null;
        if (minStr != null && maxStr != null) {
            try {
                min = Double.parseDouble(minStr);
                max = Double.parseDouble(maxStr);
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid number format in axis range");
            }
        }
        Map<Double, String> customTicks = null;
        if (ticksStr != null && (customTicks = this.parseCustomTicks(ticksStr)) == null) {
            return CommandExecutionResult.error("Invalid tick format. Expected: [value:\"label\", ...]");
        }
        Double tickSpacing = null;
        if (spacingStr != null) {
            try {
                tickSpacing = Double.parseDouble(spacingStr);
                if (tickSpacing <= 0.0) {
                    return CommandExecutionResult.error("Tick spacing must be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                return CommandExecutionResult.error("Invalid number format in spacing value");
            }
        }
        CommandExecutionResult result = axisType.startsWith("v2") ? diagram.setY2Axis(title, min, max) : diagram.setYAxis(title, min, max);
        if (customTicks != null) {
            if (axisType.startsWith("v2")) {
                if (diagram.getY2Axis() != null) {
                    diagram.getY2Axis().setCustomTicks(customTicks);
                }
            } else {
                diagram.getYAxis().setCustomTicks(customTicks);
            }
        }
        if (tickSpacing != null) {
            if (axisType.startsWith("v2")) {
                if (diagram.getY2Axis() != null) {
                    diagram.getY2Axis().setTickSpacing(tickSpacing);
                }
            } else {
                diagram.getYAxis().setTickSpacing(tickSpacing);
            }
        }
        if (labelTopStr != null) {
            if (axisType.startsWith("v2")) {
                if (diagram.getY2Axis() != null) {
                    diagram.getY2Axis().setLabelPosition(ChartAxis.LabelPosition.TOP);
                }
            } else {
                diagram.getYAxis().setLabelPosition(ChartAxis.LabelPosition.TOP);
            }
        }
        if (gridStr != null) {
            diagram.setYGridMode(ChartDiagram.GridMode.MAJOR);
        }
        return result;
    }

    private List<String> parseLabels(String data) {
        String[] parts;
        ArrayList<String> result = new ArrayList<String>();
        if (data == null || data.trim().isEmpty()) {
            return result;
        }
        for (String part : parts = data.split(",")) {
            String label = part.trim();
            if (label.startsWith("\"") && label.endsWith("\"")) {
                label = label.substring(1, label.length() - 1);
            }
            result.add(label);
        }
        return result;
    }

    private Map<Double, String> parseCustomTicks(String ticksStr) {
        String[] pairs;
        LinkedHashMap<Double, String> ticks = new LinkedHashMap<Double, String>();
        if (ticksStr == null || ticksStr.trim().isEmpty()) {
            return ticks;
        }
        for (String pair : pairs = ticksStr.split(",")) {
            int colonIndex = (pair = pair.trim()).indexOf(58);
            if (colonIndex < 0) {
                return null;
            }
            String valueStr = pair.substring(0, colonIndex).trim();
            String label = pair.substring(colonIndex + 1).trim();
            if (!label.startsWith("\"") || !label.endsWith("\"") || label.length() <= 1) {
                return null;
            }
            label = label.substring(1, label.length() - 1);
            try {
                double value = Double.parseDouble(valueStr);
                ticks.put(value, label);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return ticks;
    }
}

