/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandClock
extends SingleLineCommand2<TimingDiagram> {
    public CommandClock() {
        super(CommandClock.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandClock.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(1, "COMPACT", "(compact)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf(0, "TYPE", "clock"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(1, "FULL", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf(1, "CODE", "([%pLN_.@]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("with"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("period"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "PERIOD", "([0-9]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("pulse"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "PULSE", "([0-9]+)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("offset"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "OFFSET", "([0-9]+)"))), RegexLeaf.spaceZeroOrMore(), StereotypePattern.optional("STEREO"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String compact = arg.get("COMPACT", 0);
        String code = arg.get("CODE", 0);
        int period = Integer.parseInt(arg.get("PERIOD", 0));
        int pulse = this.getInt(arg.get("PULSE", 0));
        int offset = this.getInt(arg.get("OFFSET", 0));
        String full = arg.get("FULL", 0);
        if (full == null) {
            full = "";
        }
        String stereotypeString = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
        }
        diagram.createPlayerClock(code, full, period, pulse, offset, compact != null, stereotype);
        return CommandExecutionResult.ok();
    }

    private int getInt(String value) {
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }
}

