/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantURLPath
implements Variant {
    private static final Logger LOGGER;
    private static final char ESCAPE = '%';
    private static final BitSet PCHAR;
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();
    private String[] segments;
    private static final String SHORT_NAME = "urlpath";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void setMessage(HttpMessage msg) {
        String encodedPath = msg.getRequestHeader().getURI().getEscapedPath();
        int i = 1;
        if (encodedPath != null) {
            for (String segment : this.segments = encodedPath.split("/")) {
                if (segment.length() <= 0) continue;
                String decodedSegment = VariantURLPath.decode(segment);
                this.stringParam.add(new NameValuePair(16, decodedSegment, decodedSegment, i));
                ++i;
            }
        }
        this.stringParam.add(new NameValuePair(16, "", "", i));
        if (this.segments == null || this.segments.length == 0) {
            this.segments = new String[]{""};
        }
    }

    private static String decode(String segment) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = segment.getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                int u = Character.digit(bytes[++i], 16);
                int l = Character.digit(bytes[++i], 16);
                baos.write((u << 4) + l);
                continue;
            }
            baos.write(b);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    private static String encode(String segment) {
        if (segment == null || segment.isEmpty()) {
            return segment;
        }
        StringBuilder strBuilder = new StringBuilder();
        byte[] chars = segment.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < chars.length; ++i) {
            int b = chars[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (PCHAR.get(b)) {
                strBuilder.append((char)b);
                continue;
            }
            strBuilder.append('%').append(VariantURLPath.toHex(b >> 4)).append(VariantURLPath.toHex(b));
        }
        return strBuilder.toString();
    }

    private static char toHex(int b) {
        return Character.toUpperCase(Character.forDigit(b & 0xF, 16));
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        try {
            Object path;
            URI uri = msg.getRequestHeader().getURI();
            int position = originalPair.getPosition();
            if (position > this.segments.length) {
                throw new IllegalArgumentException("Invalid position " + position);
            }
            if (position < this.segments.length) {
                String encodedValue = escaped ? value : VariantURLPath.encode(value);
                String originalValue = this.segments[position];
                this.segments[position] = encodedValue;
                path = StringUtils.join((Object[])this.segments, (String)"/");
                this.segments[position] = originalValue;
            } else {
                path = StringUtils.join((Object[])this.segments, (String)"/") + "/" + value;
            }
            try {
                uri.setEscapedPath((String)path);
            }
            catch (URIException e) {
                uri.setPath((String)path);
            }
        }
        catch (URIException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    static {
        int i;
        LOGGER = LogManager.getLogger(VariantURLPath.class);
        PCHAR = new BitSet();
        PCHAR.set(58);
        PCHAR.set(64);
        for (i = 65; i <= 90; ++i) {
            PCHAR.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            PCHAR.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            PCHAR.set(i);
        }
        PCHAR.set(45);
        PCHAR.set(46);
        PCHAR.set(95);
        PCHAR.set(126);
        PCHAR.set(33);
        PCHAR.set(36);
        PCHAR.set(38);
        PCHAR.set(39);
        PCHAR.set(40);
        PCHAR.set(41);
        PCHAR.set(42);
        PCHAR.set(43);
        PCHAR.set(44);
        PCHAR.set(59);
        PCHAR.set(61);
        PCHAR.set(91);
        PCHAR.set(93);
    }
}

