/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TransformSpec
implements Validatable<TransformSpec> {
    public static final boolean DEF_OUTLIERS = false;
    public static final LengthOfPeriodType DEF_ADJUST = LengthOfPeriodType.None;
    public static final TransformSpec DEFAULT_NONE = (TransformSpec)TransformSpec.builder().build();
    private final TransformationType function;
    private final boolean outliersCorrection;
    private final LengthOfPeriodType adjust;
    private final double aicDiff;
    private final double constant;
    public static final double DEF_AICDIFF = -2.0;

    public static Builder builder() {
        return new Builder().function(TransformationType.None).outliersCorrection(false).adjust(DEF_ADJUST).aicDiff(-2.0);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_NONE);
    }

    public TransformSpec validate() throws IllegalArgumentException {
        return this;
    }

    @Generated
    TransformSpec(TransformationType function, boolean outliersCorrection, LengthOfPeriodType adjust, double aicDiff, double constant) {
        this.function = function;
        this.outliersCorrection = outliersCorrection;
        this.adjust = adjust;
        this.aicDiff = aicDiff;
        this.constant = constant;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().function(this.function).outliersCorrection(this.outliersCorrection).adjust(this.adjust).aicDiff(this.aicDiff).constant(this.constant);
    }

    @Generated
    public TransformationType getFunction() {
        return this.function;
    }

    @Generated
    public boolean isOutliersCorrection() {
        return this.outliersCorrection;
    }

    @Generated
    public LengthOfPeriodType getAdjust() {
        return this.adjust;
    }

    @Generated
    public double getAicDiff() {
        return this.aicDiff;
    }

    @Generated
    public double getConstant() {
        return this.constant;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformSpec)) {
            return false;
        }
        TransformSpec other = (TransformSpec)o;
        if (this.isOutliersCorrection() != other.isOutliersCorrection()) {
            return false;
        }
        if (Double.compare(this.getAicDiff(), other.getAicDiff()) != 0) {
            return false;
        }
        if (Double.compare(this.getConstant(), other.getConstant()) != 0) {
            return false;
        }
        TransformationType this$function = this.getFunction();
        TransformationType other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        LengthOfPeriodType this$adjust = this.getAdjust();
        LengthOfPeriodType other$adjust = other.getAdjust();
        return !(this$adjust == null ? other$adjust != null : !this$adjust.equals(other$adjust));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOutliersCorrection() ? 79 : 97);
        long $aicDiff = Double.doubleToLongBits(this.getAicDiff());
        result = result * 59 + (int)($aicDiff >>> 32 ^ $aicDiff);
        long $constant = Double.doubleToLongBits(this.getConstant());
        result = result * 59 + (int)($constant >>> 32 ^ $constant);
        TransformationType $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        LengthOfPeriodType $adjust = this.getAdjust();
        result = result * 59 + ($adjust == null ? 43 : $adjust.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TransformSpec(function=" + String.valueOf(this.getFunction()) + ", outliersCorrection=" + this.isOutliersCorrection() + ", adjust=" + String.valueOf(this.getAdjust()) + ", aicDiff=" + this.getAicDiff() + ", constant=" + this.getConstant() + ")";
    }

    public static class Builder
    implements Validatable.Builder<TransformSpec> {
        @Generated
        private TransformationType function;
        @Generated
        private boolean outliersCorrection;
        @Generated
        private LengthOfPeriodType adjust;
        @Generated
        private double aicDiff;
        @Generated
        private double constant;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder function(TransformationType function) {
            this.function = function;
            return this;
        }

        @Generated
        public @NonNull Builder outliersCorrection(boolean outliersCorrection) {
            this.outliersCorrection = outliersCorrection;
            return this;
        }

        @Generated
        public @NonNull Builder adjust(LengthOfPeriodType adjust) {
            this.adjust = adjust;
            return this;
        }

        @Generated
        public @NonNull Builder aicDiff(double aicDiff) {
            this.aicDiff = aicDiff;
            return this;
        }

        @Generated
        public @NonNull Builder constant(double constant) {
            this.constant = constant;
            return this;
        }

        @Generated
        public @NonNull TransformSpec buildWithoutValidation() {
            return new TransformSpec(this.function, this.outliersCorrection, this.adjust, this.aicDiff, this.constant);
        }

        @Generated
        public @NonNull String toString() {
            return "TransformSpec.Builder(function=" + String.valueOf(this.function) + ", outliersCorrection=" + this.outliersCorrection + ", adjust=" + String.valueOf(this.adjust) + ", aicDiff=" + this.aicDiff + ", constant=" + this.constant + ")";
        }
    }
}

