/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.extremevaluecorrector;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.x13.base.api.x11.SigmaVecOption;
import jdplus.x13.base.core.x11.extremevaluecorrector.PeriodSpecificExtremeValuesCorrector;

public class GroupSpecificExtremeValuesCorrector
extends PeriodSpecificExtremeValuesCorrector {
    private final SigmaVecOption[] sigmavecOption_;

    public GroupSpecificExtremeValuesCorrector(SigmaVecOption[] sigmavecOption) {
        this.sigmavecOption_ = sigmavecOption;
    }

    @Override
    protected double[] calcStdev(DoubleSeq s) {
        int i;
        DataBlock db = DataBlock.of((DoubleSeq)s);
        if (this.excludeFcast) {
            db = db.drop(0, this.forecastHorizon);
        }
        Integer np = this.period;
        double[] stdev = new double[np.intValue()];
        double stdvGroup1 = 0.0;
        double stdvGroup2 = 0.0;
        int nGroup1 = 0;
        int nGroup2 = 0;
        double eGroup1 = 0.0;
        double eGroup2 = 0.0;
        for (i = 0; i < this.period; ++i) {
            double x;
            int k;
            int j = ((this.period - this.start) % this.period + i) % this.period;
            DataBlock dbPeriod = db.extract(j, -1, this.period);
            if (this.sigmavecOption_[i].equals((Object)SigmaVecOption.Group1)) {
                for (k = 0; k < dbPeriod.length(); ++k) {
                    x = dbPeriod.get(k);
                    if (Double.isNaN(x)) continue;
                    ++nGroup1;
                    if (this.mul) {
                        x -= 1.0;
                    }
                    eGroup1 += x * x;
                }
                continue;
            }
            if (!this.sigmavecOption_[i].equals((Object)SigmaVecOption.Group2)) continue;
            for (k = 0; k < dbPeriod.length(); ++k) {
                x = dbPeriod.get(k);
                if (Double.isNaN(x)) continue;
                ++nGroup2;
                if (this.mul) {
                    x -= 1.0;
                }
                eGroup2 += x * x;
            }
        }
        stdvGroup1 = Math.sqrt(eGroup1 / (double)nGroup1);
        stdvGroup2 = Math.sqrt(eGroup2 / (double)nGroup2);
        for (i = 0; i < np; ++i) {
            if (this.sigmavecOption_[i].equals((Object)SigmaVecOption.Group1)) {
                stdev[i] = stdvGroup1;
                continue;
            }
            if (!this.sigmavecOption_[i].equals((Object)SigmaVecOption.Group2)) continue;
            stdev[i] = stdvGroup2;
        }
        return stdev;
    }
}

