/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5PBprivate_H
#define H5PBprivate_H

#include "H5private.h"   
#include "H5Fprivate.h"  
#include "H5FLprivate.h" 
#include "H5SLprivate.h" 

#define H5PB_SIZE_DEFAULT_VALUE 0

struct H5PB_entry_t;

typedef struct H5PB_t {
    size_t   max_size;       
    size_t   page_size;      
    unsigned min_meta_perc;  
    unsigned min_raw_perc;   
    unsigned meta_count;     
    unsigned raw_count;      
    unsigned min_meta_count; 
    unsigned min_raw_count;  

    H5SL_t *slist_ptr;    
    H5SL_t *mf_slist_ptr; 

    size_t               LRU_list_len; 
    struct H5PB_entry_t *LRU_head_ptr; 
    struct H5PB_entry_t *LRU_tail_ptr; 

    H5FL_fac_head_t *page_fac; 

    
    unsigned accesses[2];
    unsigned hits[2];
    unsigned misses[2];
    unsigned evictions[2];
    unsigned bypasses[2];
} H5PB_t;

H5_DLL herr_t H5PB_create(H5F_shared_t *f_sh, size_t page_buffer_size, unsigned page_buf_min_meta_perc,
                          unsigned page_buf_min_raw_perc);
H5_DLL herr_t H5PB_flush(H5F_shared_t *f_sh);
H5_DLL herr_t H5PB_dest(H5F_shared_t *f_sh);
H5_DLL herr_t H5PB_add_new_page(H5F_shared_t *f_sh, H5FD_mem_t type, haddr_t page_addr);
H5_DLL herr_t H5PB_update_entry(H5PB_t *page_buf, haddr_t addr, size_t size, const void *buf);
H5_DLL herr_t H5PB_remove_entry(const H5F_shared_t *f_sh, haddr_t addr);
H5_DLL herr_t H5PB_read(H5F_shared_t *f_sh, H5FD_mem_t type, haddr_t addr, size_t size, void *buf );
H5_DLL herr_t H5PB_write(H5F_shared_t *f_sh, H5FD_mem_t type, haddr_t addr, size_t size, const void *buf);
H5_DLL herr_t H5PB_enabled(H5F_shared_t *f_sh, H5FD_mem_t type, bool *enabled);

H5_DLL herr_t H5PB_reset_stats(H5PB_t *page_buf);
H5_DLL herr_t H5PB_get_stats(const H5PB_t *page_buf, unsigned accesses[2], unsigned hits[2],
                             unsigned misses[2], unsigned evictions[2], unsigned bypasses[2]);
H5_DLL herr_t H5PB_print_stats(const H5PB_t *page_buf);

#endif 
