## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(distionary)

## -----------------------------------------------------------------------------
# Make a Null distribution.
null <- dst_null()
# Inspect
null

## -----------------------------------------------------------------------------
dst_norm(mean = 0, sd = NA)

## -----------------------------------------------------------------------------
mean(null)
eval_pmf(null, at = 1:10)
range(null)

## -----------------------------------------------------------------------------
set.seed(42)
normal <- dst_norm(0, 1)
x <- realise(normal, n = 100)
# Inspect the first few observations
head(x)

## -----------------------------------------------------------------------------
empirical <- dst_empirical(x)
# Inspect
empirical

## -----------------------------------------------------------------------------
plot(empirical, "cdf", from = -4, to = 4, n = 1000)
plot(normal, "cdf", add = TRUE, col = "red")
legend(
  "topleft", 
  legend = c("Empirical", "Normal"), 
  col = c("black", "red"), 
  lty = 1
)

## -----------------------------------------------------------------------------
str(parameters(empirical))

## -----------------------------------------------------------------------------
vtype(empirical)

