/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jpmml.rexp.RDataOutput;

public abstract class TextOutput
implements RDataOutput {
    private Writer writer = null;

    public TextOutput(OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        ((Writer)writer).write(65);
        ((Writer)writer).write(10);
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public String escape(String string) {
        return TextOutput.encode(string);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.writer.write(String.valueOf(value));
        this.writer.write(10);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writer.write(String.valueOf(value));
        this.writer.write(10);
    }

    @Override
    public void writeByteArray(byte[] bytes) throws IOException {
        this.writer.write(new String(bytes));
        this.writer.write(10);
    }

    public static String encode(String string) {
        StringBuilder sb = new StringBuilder(2 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c <= '\u001f' || c == ' ' || c >= '\u007f') {
                sb.append('\\').append(Integer.toOctalString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

