/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.bayes;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.bayes.BayesRegularizedRegressionModel;
import jdplus.toolkit.base.core.bayes.BayesRegularizedRegressionResults;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.random.MersenneTwister;
import jdplus.toolkit.base.core.stats.samples.Moments;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BayesRegularizedRegressionProcessor {
    private final RandomNumberGenerator rng = MersenneTwister.fromSystemNanoTime();
    private final Spec spec;
    private BayesRegularizedRegressionModel model;
    private int n;
    private int p;
    private DataBlock z;
    private double muZ;
    private double ztz;
    private FastMatrix X;
    private double[] muX;
    private double[] stdX;
    private double b0;
    private DataBlock b;
    private DataBlock omega2;
    private double sigma2;
    private double muSigma2;
    private double tau2;
    private double xi;
    private double psi2;
    private double muPsi2;
    private DataBlock lambda2;
    private DataBlock nu;
    private DataBlock phi2;
    private DataBlock zeta;
    private DataBlock w2;
    private DataBlock e;
    private DataBlock waicProb;
    private DataBlock waicLProb;
    private DataBlock waicLProb2;
    private boolean mvnrue;
    private FastMatrix XtX;
    private DataBlock Xtz;

    public BayesRegularizedRegressionProcessor(Spec spec) {
        this.spec = spec;
    }

    public BayesRegularizedRegressionResults process(BayesRegularizedRegressionModel model) {
        this.clear();
        this.initialize(model);
        if (this.spec.isNormalize()) {
            this.standardize(false);
        }
        this.precompute();
        return null;
    }

    private void clear() {
        this.model = null;
        this.n = 0;
        this.p = 0;
        this.z = null;
        this.muZ = 0.0;
        this.X = null;
        this.muX = null;
        this.stdX = null;
    }

    private void initialize(BayesRegularizedRegressionModel model) {
        this.model = model;
        this.z = DataBlock.of(model.getY().toArray());
        this.X = FastMatrix.of(model.getX());
        this.n = this.z.length();
        this.p = this.X.getColumnsCount();
        this.b0 = 0.0;
        this.b = DataBlock.of(this.p, () -> Normal.random(this.rng, 0.0, 1.0));
        this.sigma2 = 1.0;
        this.e = null;
        this.tau2 = 1.0;
        this.xi = 0.001;
        this.lambda2 = DataBlock.make(this.p, 1.0);
        this.omega2 = DataBlock.make(this.n, 1.0);
        this.nu = DataBlock.make(this.p, 1.0);
        this.phi2 = DataBlock.make(this.p, 1.0);
        this.zeta = DataBlock.make(this.p, 1.0);
        this.psi2 = 1.0;
        this.muPsi2 = 0.0;
        this.w2 = DataBlock.make(this.p, 1.0);
        this.waicProb = DataBlock.make(this.n);
        this.waicLProb = DataBlock.make(this.n);
        this.waicLProb2 = DataBlock.make(this.n);
        this.mvnrue = this.p < 2 * this.n;
        this.XtX = null;
        this.Xtz = null;
    }

    private void standardize(boolean bz) {
        this.muX = new double[this.p];
        this.stdX = new double[this.p];
        int pos = 0;
        DataBlockIterator cols = this.X.columnsIterator();
        while (cols.hasNext()) {
            DataBlock col = cols.next();
            double mean = Moments.mean((DoubleSeq)col);
            double std = Math.sqrt(Moments.variance((DoubleSeq)col, mean, false) * (double)this.n);
            col.apply(a -> (a - mean) / std);
            this.muX[pos] = mean;
            this.stdX[pos++] = std;
        }
        if (bz) {
            this.muZ = this.z.average();
            this.z.sub(this.muZ);
        }
    }

    private boolean isGaussian() {
        return this.model.getModel() == BayesRegularizedRegressionModel.ModelType.GAUSSIAN;
    }

    private void precompute() {
        if (this.isGaussian() && this.mvnrue || this.model.getPrior() == BayesRegularizedRegressionModel.Prior.G) {
            if (this.isGaussian()) {
                this.Xtz = DataBlock.make(this.p);
                this.Xtz.product(this.z, this.X.columnsIterator());
                this.ztz = this.z.ssq();
            }
            this.XtX = SymmetricMatrix.XtX(this.X);
        }
    }

    private double tauA() {
        switch (this.model.getTau2Prior()) {
            case HC: {
                return 0.5;
            }
            case SB: {
                return 0.5;
            }
        }
        return 1.0;
    }

    private double tauB() {
        switch (this.model.getTau2Prior()) {
            case HC: {
                return 0.5;
            }
            case SB: {
                return 1.0;
            }
        }
        return 1.0;
    }

    public static final class Spec {
        private final int nsamples;
        private final int burnin;
        private final int thin;
        private final int blocksize;
        private final boolean waic;
        private final boolean normalize;

        public static Builder builder() {
            return new Builder().nsamples(1000).burnin(1000).thin(5).normalize(true);
        }

        @Generated
        Spec(int nsamples, int burnin, int thin, int blocksize, boolean waic, boolean normalize) {
            this.nsamples = nsamples;
            this.burnin = burnin;
            this.thin = thin;
            this.blocksize = blocksize;
            this.waic = waic;
            this.normalize = normalize;
        }

        @Generated
        public int getNsamples() {
            return this.nsamples;
        }

        @Generated
        public int getBurnin() {
            return this.burnin;
        }

        @Generated
        public int getThin() {
            return this.thin;
        }

        @Generated
        public int getBlocksize() {
            return this.blocksize;
        }

        @Generated
        public boolean isWaic() {
            return this.waic;
        }

        @Generated
        public boolean isNormalize() {
            return this.normalize;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spec)) {
                return false;
            }
            Spec other = (Spec)o;
            if (this.getNsamples() != other.getNsamples()) {
                return false;
            }
            if (this.getBurnin() != other.getBurnin()) {
                return false;
            }
            if (this.getThin() != other.getThin()) {
                return false;
            }
            if (this.getBlocksize() != other.getBlocksize()) {
                return false;
            }
            if (this.isWaic() != other.isWaic()) {
                return false;
            }
            return this.isNormalize() == other.isNormalize();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNsamples();
            result = result * 59 + this.getBurnin();
            result = result * 59 + this.getThin();
            result = result * 59 + this.getBlocksize();
            result = result * 59 + (this.isWaic() ? 79 : 97);
            result = result * 59 + (this.isNormalize() ? 79 : 97);
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "BayesRegularizedRegressionProcessor.Spec(nsamples=" + this.getNsamples() + ", burnin=" + this.getBurnin() + ", thin=" + this.getThin() + ", blocksize=" + this.getBlocksize() + ", waic=" + this.isWaic() + ", normalize=" + this.isNormalize() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private int nsamples;
            @Generated
            private int burnin;
            @Generated
            private int thin;
            @Generated
            private int blocksize;
            @Generated
            private boolean waic;
            @Generated
            private boolean normalize;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder nsamples(int nsamples) {
                this.nsamples = nsamples;
                return this;
            }

            @Generated
            public @NonNull Builder burnin(int burnin) {
                this.burnin = burnin;
                return this;
            }

            @Generated
            public @NonNull Builder thin(int thin) {
                this.thin = thin;
                return this;
            }

            @Generated
            public @NonNull Builder blocksize(int blocksize) {
                this.blocksize = blocksize;
                return this;
            }

            @Generated
            public @NonNull Builder waic(boolean waic) {
                this.waic = waic;
                return this;
            }

            @Generated
            public @NonNull Builder normalize(boolean normalize) {
                this.normalize = normalize;
                return this;
            }

            @Generated
            public @NonNull Spec build() {
                return new Spec(this.nsamples, this.burnin, this.thin, this.blocksize, this.waic, this.normalize);
            }

            @Generated
            public @NonNull String toString() {
                return "BayesRegularizedRegressionProcessor.Spec.Builder(nsamples=" + this.nsamples + ", burnin=" + this.burnin + ", thin=" + this.thin + ", blocksize=" + this.blocksize + ", waic=" + this.waic + ", normalize=" + this.normalize + ")";
            }
        }
    }
}

