/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class TrendConstantFactory
implements RegressionVariableFactory<TrendConstant> {
    private static final Map<Key, Data> CACHE = new HashMap<Key, Data>();
    static TrendConstantFactory FACTORY = new TrendConstantFactory();

    private static Data compute(Key key, int n) {
        double[] D = UnitRoots.D(key.getD()).times(UnitRoots.D(key.getPeriod(), key.getBd())).toArray();
        int d = D.length - 1;
        if (n < d) {
            n = d;
        }
        double[] m = new double[n];
        for (int i = d; i < n; ++i) {
            double s = 1.0;
            for (int j = 1; j <= d; ++j) {
                s -= m[i - j] * D[j];
            }
            m[i] = s;
        }
        return new Data(0, m);
    }

    private static Data fextend(Key key, Data cur, int n) {
        int i;
        double[] dcur = cur.getData();
        if (n <= dcur.length - cur.start) {
            return cur;
        }
        double[] D = UnitRoots.D(key.getD()).times(UnitRoots.D(key.getPeriod(), key.getBd())).toArray();
        int d = D.length - 1;
        double[] m = new double[cur.start + n];
        for (i = 0; i < dcur.length; ++i) {
            m[i] = dcur[i];
        }
        for (i = dcur.length; i < m.length; ++i) {
            double s = 1.0;
            for (int j = 1; j <= d; ++j) {
                s -= m[i - j] * D[j];
            }
            m[i] = s;
        }
        return new Data(cur.start, m);
    }

    private static Data bextend(Key key, Data cur, int n) {
        double[] dcur = cur.getData();
        int del = n - cur.start;
        if (del < 0) {
            return cur;
        }
        double[] D = UnitRoots.D(key.getD()).times(UnitRoots.D(key.getPeriod(), key.getBd())).mirror().toArray();
        int d = D.length - 1;
        double[] m = new double[del + dcur.length];
        int i = del;
        for (int j = 0; j < dcur.length; ++j) {
            m[i] = dcur[j];
            ++i;
        }
        double a = D[0];
        for (int i2 = del - 1; i2 >= 0; --i2) {
            double s = 1.0;
            for (int j = 1; j <= d; ++j) {
                s -= m[i2 + j] * D[j];
            }
            m[i2] = s / a;
        }
        return new Data(n, m);
    }

    private static Data dataFor(Key key, int start, int n) {
        return CACHE.compute(key, (k, v) -> {
            v = v == null ? TrendConstantFactory.compute(k, n) : TrendConstantFactory.fextend(k, v, n);
            if (start < 0) {
                v = TrendConstantFactory.bextend(k, v, -start);
            }
            return v;
        });
    }

    private TrendConstantFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fill(TrendConstant var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int n = buffer.getRowsCount();
        int beg = 0;
        if (var.getReference() != null) {
            TsPeriod ref = start.withDate(var.getReference());
            beg = ref.until(start);
        }
        Map<Key, Data> map = CACHE;
        synchronized (map) {
            Data data = TrendConstantFactory.dataFor(new Key(var.getD(), var.getBd(), start.annualFrequency()), beg, n + beg);
            buffer.column(0).copyFrom(data.data, data.start + beg);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TrendConstant var, D domain, FastMatrix buffer, ProcessingLog log) {
        return false;
    }

    private static final class Key {
        private final int d;
        private final int bd;
        private final int period;

        @Generated
        public Key(int d, int bd, int period) {
            this.d = d;
            this.bd = bd;
            this.period = period;
        }

        @Generated
        public int getD() {
            return this.d;
        }

        @Generated
        public int getBd() {
            return this.bd;
        }

        @Generated
        public int getPeriod() {
            return this.period;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (this.getD() != other.getD()) {
                return false;
            }
            if (this.getBd() != other.getBd()) {
                return false;
            }
            return this.getPeriod() == other.getPeriod();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getD();
            result = result * 59 + this.getBd();
            result = result * 59 + this.getPeriod();
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TrendConstantFactory.Key(d=" + this.getD() + ", bd=" + this.getBd() + ", period=" + this.getPeriod() + ")";
        }
    }

    private static final class Data {
        private final int start;
        private final double[] data;

        @Generated
        public Data(int start, double[] data) {
            this.start = start;
            this.data = data;
        }

        @Generated
        public int getStart() {
            return this.start;
        }

        @Generated
        public double[] getData() {
            return this.data;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStart();
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TrendConstantFactory.Data(start=" + this.getStart() + ", data=" + Arrays.toString(this.getData()) + ")";
        }
    }
}

