/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import java.util.Arrays;
import jdplus.sa.base.core.tests.Item;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class KruskalWallis {
    private double h;
    private final int period;

    public KruskalWallis(DoubleSeq sample, int period) {
        this.period = period;
        if (period <= 1) {
            throw new StatException();
        }
        double[] data = sample.toArray();
        Object[] items = new Item[data.length];
        int N = 0;
        int[] nk = new int[period];
        int j = 0;
        for (int i = 0; i < items.length; ++i) {
            double d = data[i];
            if (!Double.isFinite(d)) continue;
            int k = i % period;
            items[j++] = new Item(k, d);
            int n = k;
            nk[n] = nk[n] + 1;
        }
        N = j;
        Arrays.sort(items, 0, N);
        double[] S = new double[period];
        int i = 0;
        while (i < N) {
            int j1;
            int j0 = i;
            for (j1 = i + 1; j1 < N && ((Item)items[j0]).val == ((Item)items[j1]).val; ++j1) {
            }
            int n = j1 - j0;
            if (n == 1) {
                int n2 = ((Item)items[i]).pos;
                S[n2] = S[n2] + (double)(i + 1);
            } else {
                double dpos = (double)j0 + 0.5 * (double)(n + 1);
                for (int jcur = j0; jcur < j1; ++jcur) {
                    int n3 = ((Item)items[jcur]).pos;
                    S[n3] = S[n3] + dpos;
                }
            }
            i = j1;
        }
        this.h = 0.0;
        for (i = 0; i < period; ++i) {
            this.h += S[i] * S[i] / (double)nk[i];
        }
        this.h = 12.0 * this.h / (double)(N * (N + 1)) - (double)(3 * (N + 1));
    }

    public StatisticalTest build() {
        return TestsUtility.testOf((double)this.h, (ContinuousDistribution)new Chi2((double)(this.period - 1)), (TestType)TestType.Upper);
    }
}

