/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.dictionaries;

import java.util.stream.Stream;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import lombok.Generated;

public class PrefixedDictionary
implements Dictionary {
    String path;
    Dictionary core;
    Dictionary.EntryType type;

    public PrefixedDictionary(String path, Dictionary core) {
        this(path, core, Dictionary.EntryType.Normal);
    }

    @Override
    public Stream<? extends Dictionary.Entry> entries() {
        return this.path == null || this.path.length() == 0 ? this.core.entries() : this.core.entries().map(entry -> new DerivedItem((Dictionary.Entry)entry));
    }

    @Override
    public Stream<String> keys() {
        return this.path == null || this.path.length() == 0 ? this.core.keys() : this.core.keys().map(keyitem -> PrefixedDictionary.derivedName(Dictionary.fullName(this.path, this.type), keyitem));
    }

    @Override
    public Stream<String> keys(Class tclass) {
        return this.path == null || this.path.length() == 0 ? this.core.keys(tclass) : this.core.keys().filter(item -> tclass.isAssignableFrom(item.getClass())).map(keyitem -> PrefixedDictionary.derivedName(Dictionary.fullName(this.path, this.type), keyitem));
    }

    private static String derivedName(String path, String name) {
        return path + '.' + name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Dictionary getCore() {
        return this.core;
    }

    @Generated
    public Dictionary.EntryType getType() {
        return this.type;
    }

    @Generated
    public PrefixedDictionary(String path, Dictionary core, Dictionary.EntryType type) {
        this.path = path;
        this.core = core;
        this.type = type;
    }

    public class DerivedItem
    implements Dictionary.Entry {
        Dictionary.Entry core;

        @Override
        public String getName() {
            return PrefixedDictionary.derivedName(Dictionary.fullName(PrefixedDictionary.this.path, PrefixedDictionary.this.type), this.core.getName());
        }

        @Override
        public String getDescription() {
            return this.core.getDescription();
        }

        @Override
        public String getDetail() {
            return this.core.getDetail();
        }

        @Override
        public Class getOutputClass() {
            return this.core.getOutputClass();
        }

        @Override
        public Dictionary.EntryType getType() {
            return this.core.getType();
        }

        @Generated
        public Dictionary.Entry getCore() {
            return this.core;
        }

        @Generated
        public DerivedItem(Dictionary.Entry core) {
            this.core = core;
        }
    }
}

