/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import jdplus.toolkit.base.api.util.LinearId;
import lombok.NonNull;

public interface Id
extends Comparable<Id> {
    public static Id empty() {
        return LinearId.EMPTY;
    }

    public String get(int var1);

    public Id extend(String var1);

    public Id parent();

    public int getCount();

    public String toString();

    default public String tail() {
        int n = this.getCount();
        return n > 0 ? this.get(n - 1) : null;
    }

    default public Id[] path() {
        int n = this.getCount();
        if (n == 0) {
            return new Id[0];
        }
        Id[] result = new Id[n];
        Id cur = this;
        while (n > 0) {
            result[--n] = cur;
            cur = cur.parent();
        }
        return result;
    }

    default public boolean startsWith(Id that) {
        int sn = that.getCount();
        if (sn > this.getCount()) {
            return false;
        }
        for (int i = 0; i < sn; ++i) {
            if (this.get(i).equals(that.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    default public int compareTo(Id that) {
        int rn;
        int ln = this.getCount();
        if (ln < (rn = that.getCount())) {
            return -1;
        }
        if (ln > rn) {
            return 1;
        }
        for (int i = 0; i < ln; ++i) {
            int cmp = this.get(i).compareTo(that.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @NonNull
    default public String[] toArray() {
        String[] result = new String[this.getCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }
}

