/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.text;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="TextModelNormalization", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="TextModelNormalization")
@JsonPropertyOrder(value={"localTermWeights", "globalTermWeights", "documentNormalization", "extensions"})
public class TextModelNormalization
extends PMMLObject
implements HasExtensions<TextModelNormalization> {
    @XmlAttribute(name="localTermWeights")
    @JsonProperty(value="localTermWeights")
    private LocalTermWeights localTermWeights;
    @XmlAttribute(name="globalTermWeights")
    @JsonProperty(value="globalTermWeights")
    private GlobalTermWeights globalTermWeights;
    @XmlAttribute(name="documentNormalization")
    @JsonProperty(value="documentNormalization")
    private DocumentNormalization documentNormalization;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371275L;

    public LocalTermWeights getLocalTermWeights() {
        if (this.localTermWeights == null) {
            return LocalTermWeights.TERM_FREQUENCY;
        }
        return this.localTermWeights;
    }

    public TextModelNormalization setLocalTermWeights(@Property(value="localTermWeights") LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public GlobalTermWeights getGlobalTermWeights() {
        if (this.globalTermWeights == null) {
            return GlobalTermWeights.INVERSE_DOCUMENT_FREQUENCY;
        }
        return this.globalTermWeights;
    }

    public TextModelNormalization setGlobalTermWeights(@Property(value="globalTermWeights") GlobalTermWeights globalTermWeights) {
        this.globalTermWeights = globalTermWeights;
        return this;
    }

    public DocumentNormalization getDocumentNormalization() {
        if (this.documentNormalization == null) {
            return DocumentNormalization.NONE;
        }
        return this.documentNormalization;
    }

    public TextModelNormalization setDocumentNormalization(@Property(value="documentNormalization") DocumentNormalization documentNormalization) {
        this.documentNormalization = documentNormalization;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextModelNormalization addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LocalTermWeights implements StringValue<LocalTermWeights>
    {
        TERM_FREQUENCY("termFrequency"),
        BINARY("binary"),
        LOGARITHMIC("logarithmic"),
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");

        private final String value;

        private LocalTermWeights(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static LocalTermWeights fromValue(String v) {
            for (LocalTermWeights c : LocalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum GlobalTermWeights implements StringValue<GlobalTermWeights>
    {
        INVERSE_DOCUMENT_FREQUENCY("inverseDocumentFrequency"),
        NONE("none"),
        GFIDF("GFIDF"),
        NORMAL("normal"),
        PROBABILISTIC_INVERSE("probabilisticInverse");

        private final String value;

        private GlobalTermWeights(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static GlobalTermWeights fromValue(String v) {
            for (GlobalTermWeights c : GlobalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum DocumentNormalization implements StringValue<DocumentNormalization>
    {
        NONE("none"),
        COSINE("cosine");

        private final String value;

        private DocumentNormalization(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static DocumentNormalization fromValue(String v) {
            for (DocumentNormalization c : DocumentNormalization.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

