/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import lombok.Generated;
import lombok.NonNull;

public class DefaultTsFactory
implements TsFactory {
    private final List<TsProvider> providers;

    @Override
    @NonNull
    public Optional<TsProvider> getProvider(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.providers.stream().filter(provider -> provider.getSource().equals(name)).findFirst();
    }

    @Override
    public Stream<TsProvider> getProviders() {
        return this.providers.stream();
    }

    public static Ts fallbackTs(TsMoniker moniker, TsData data) {
        return Ts.builder().moniker(moniker).type(TsInformationType.None).data(data).build();
    }

    public static TsCollection fallbackTsCollection(TsMoniker moniker, String emptyMessage) {
        return TsCollection.builder().moniker(moniker).type(TsInformationType.None).emptyCause(emptyMessage).build();
    }

    @Generated
    DefaultTsFactory(List<TsProvider> providers) {
        this.providers = providers;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<TsProvider> providers;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder provider(TsProvider provider) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.add(provider);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder providers(@org.jspecify.annotations.NonNull Collection<? extends TsProvider> providers) {
            if (providers == null) {
                throw new NullPointerException("providers cannot be null");
            }
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.addAll(providers);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearProviders() {
            if (this.providers != null) {
                this.providers.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull DefaultTsFactory build() {
            return new DefaultTsFactory(switch (this.providers == null ? 0 : this.providers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.providers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TsProvider>(this.providers));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "DefaultTsFactory.Builder(providers=" + String.valueOf(this.providers) + ")";
        }
    }
}

