/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import java.util.List;
import jdplus.toolkit.base.api.processing.ProcQuality;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ProcDiagnostic {
    private final double value;
    @NonNull
    private final ProcQuality quality;
    @NonNull
    private final String diagnostic;
    @NonNull
    private final String category;
    private final Object details;

    public static ProcQuality summary(@NonNull List<ProcDiagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new NullPointerException("diagnostics is marked non-null but is null");
        }
        ProcQuality rslt = ProcQuality.Undefined;
        int sum = 0;
        int n = 0;
        if (diagnostics.isEmpty()) {
            return rslt;
        }
        for (ProcDiagnostic diag : diagnostics) {
            ProcQuality quality = diag.quality;
            switch (quality) {
                case Error: {
                    return ProcQuality.Error;
                }
                case Severe: {
                    return ProcQuality.Severe;
                }
                case Good: {
                    ++n;
                    sum += 3;
                    break;
                }
                case Uncertain: {
                    ++n;
                    sum += 2;
                    break;
                }
                case Bad: {
                    ++n;
                }
            }
        }
        if (n > 0) {
            double val = sum;
            rslt = (val /= (double)n) >= 2.5 ? ProcQuality.Good : (val >= 1.5 ? ProcQuality.Uncertain : ProcQuality.Bad);
        }
        return rslt;
    }

    @Generated
    ProcDiagnostic(double value, @NonNull ProcQuality quality, @NonNull String diagnostic, @NonNull String category, Object details) {
        if (quality == null) {
            throw new NullPointerException("quality is marked non-null but is null");
        }
        if (diagnostic == null) {
            throw new NullPointerException("diagnostic is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        this.value = value;
        this.quality = quality;
        this.diagnostic = diagnostic;
        this.category = category;
        this.details = details;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public ProcQuality getQuality() {
        return this.quality;
    }

    @NonNull
    @Generated
    public String getDiagnostic() {
        return this.diagnostic;
    }

    @NonNull
    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Object getDetails() {
        return this.details;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcDiagnostic)) {
            return false;
        }
        ProcDiagnostic other = (ProcDiagnostic)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        ProcQuality this$quality = this.getQuality();
        ProcQuality other$quality = other.getQuality();
        if (this$quality == null ? other$quality != null : !((Object)((Object)this$quality)).equals((Object)other$quality)) {
            return false;
        }
        String this$diagnostic = this.getDiagnostic();
        String other$diagnostic = other.getDiagnostic();
        if (this$diagnostic == null ? other$diagnostic != null : !this$diagnostic.equals(other$diagnostic)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        Object this$details = this.getDetails();
        Object other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        ProcQuality $quality = this.getQuality();
        result = result * 59 + ($quality == null ? 43 : ((Object)((Object)$quality)).hashCode());
        String $diagnostic = this.getDiagnostic();
        result = result * 59 + ($diagnostic == null ? 43 : $diagnostic.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        Object $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ProcDiagnostic(value=" + this.getValue() + ", quality=" + String.valueOf((Object)this.getQuality()) + ", diagnostic=" + this.getDiagnostic() + ", category=" + this.getCategory() + ", details=" + String.valueOf(this.getDetails()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private double value;
        @Generated
        private ProcQuality quality;
        @Generated
        private String diagnostic;
        @Generated
        private String category;
        @Generated
        private Object details;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder value(double value) {
            this.value = value;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder quality(@NonNull ProcQuality quality) {
            if (quality == null) {
                throw new NullPointerException("quality is marked non-null but is null");
            }
            this.quality = quality;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder diagnostic(@NonNull String diagnostic) {
            if (diagnostic == null) {
                throw new NullPointerException("diagnostic is marked non-null but is null");
            }
            this.diagnostic = diagnostic;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder category(@NonNull String category) {
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            this.category = category;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder details(Object details) {
            this.details = details;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull ProcDiagnostic build() {
            return new ProcDiagnostic(this.value, this.quality, this.diagnostic, this.category, this.details);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ProcDiagnostic.Builder(value=" + this.value + ", quality=" + String.valueOf((Object)this.quality) + ", diagnostic=" + this.diagnostic + ", category=" + this.category + ", details=" + String.valueOf(this.details) + ")";
        }
    }
}

