## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
# Note: Vignettes are built in a clean environment.
# All package dependencies must be loaded.
library(annotaR)
library(dplyr)
library(ggplot2)

## ----setup--------------------------------------------------------------------
# A small list of well-known genes involved in cancer
genes_of_interest <- c(
  "TP53", "EGFR", "BRCA1", "BRCA2", "KRAS", "PIK3CA", "AKT1", "BRAF",
  "MYC", "ERBB2", "CDKN2A", "PTEN"
)

# Create the initial object
annotaR_obj <- annotaR(genes_of_interest)

print(annotaR_obj)

## ----annotation, eval=TRUE----------------------------------------------------
# Note: The following steps query live APIs and may take a few moments.

full_annotation <- annotaR_obj %>%
  add_go_terms(sources = c("GO:BP")) %>%
  add_disease_links() %>%
  add_drug_links()

# Take a look at the resulting tidy data frame
# Use `head()` to show just the first few rows
head(full_annotation)

## ----plotting, fig.width=7, fig.height=6--------------------------------------
# The plot function uses the data from the `add_go_terms` step
plot_enrichment_dotplot(
  full_annotation,
  n_terms = 20,
  title = "Top 20 Enriched GO Biological Processes"
)

