/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;

public class MovingAverageDistance {
    public static double compute(IArimaModel a, IArimaModel b, int npi) {
        StationaryTransformation sta = a.stationaryTransformation();
        StationaryTransformation stb = b.stationaryTransformation();
        if (!sta.getUnitRoots().asPolynomial().equals(stb.getUnitRoots().asPolynomial(), 1.0E-6)) {
            return -1.0;
        }
        RationalBackFilter pia = ((IArimaModel)sta.getStationaryModel()).getPsiWeights();
        RationalBackFilter pib = ((IArimaModel)stb.getStationaryModel()).getPsiWeights();
        double[] wa = pia.getWeights(npi + 1);
        double[] wb = pib.getWeights(npi + 1);
        double d = 0.0;
        for (int i = 1; i <= npi; ++i) {
            double di = wa[i] - wb[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }
}

