/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.data.analysis.Taper;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;

public class SmoothedPeriodogram {
    private final double[] p;
    private final int resolution;

    public static Builder builder() {
        return new Builder();
    }

    private SmoothedPeriodogram(double[] p, int resolution) {
        this.p = p;
        this.resolution = resolution;
    }

    public double spectrumValueAtFrequency(double freq) {
        int ipos = (int)Math.round(freq * (double)this.resolution / (Math.PI * 2));
        if (ipos == this.p.length) {
            ipos = this.p.length - 1;
        }
        if (ipos < 0 || ipos >= this.p.length) {
            return Double.NaN;
        }
        return this.p[ipos];
    }

    public DoubleSeq spectrumValues() {
        return DoubleSeq.of((double[])this.p);
    }

    public static class Builder {
        private WindowFunction win = WindowFunction.Tukey;
        private int winLen = 44;
        private int resolution = 0;
        private Taper taper = null;
        private DoubleSeq data;

        private Builder() {
        }

        public Builder data(DoubleSeq data) {
            this.data = data;
            return this;
        }

        public Builder taper(Taper taper) {
            this.taper = taper;
            return this;
        }

        public Builder windowFunction(WindowFunction win) {
            this.win = win;
            return this;
        }

        public Builder windowLength(int windowLength) {
            this.winLen = windowLength;
            return this;
        }

        public Builder resolution(int resolution) {
            this.resolution = resolution;
            return this;
        }

        public SmoothedPeriodogram build() {
            if (this.data == null) {
                throw new RuntimeException("Uninitialized data");
            }
            if (this.winLen >= this.data.length()) {
                throw new RuntimeException("Not enough data");
            }
            double[] x = this.data.toArray();
            double mean = DoublesMath.averageWithMissing((DoubleSeq)this.data);
            if (mean != 0.0) {
                int i = 0;
                while (i < x.length) {
                    int n = i++;
                    x[n] = x[n] - mean;
                }
            }
            if (this.taper != null) {
                this.taper.process(x);
            }
            DoubleSeq datac = DoubleSeq.of((double[])x);
            double[] ac = AutoCovariances.autoCovariancesWithZeroMean((DoubleSeq)datac, (int)(this.winLen - 1));
            double[] cwnd = this.win.discreteWindow(this.winLen);
            for (int i = 1; i < this.winLen; ++i) {
                int n = i;
                ac[n] = ac[n] * (cwnd[i] / ac[0]);
            }
            ac[0] = 1.0;
            int res = this.resolution != 0 ? this.resolution : this.winLen;
            int nres = 1 + res / 2;
            double[] p = new double[nres];
            for (int i = 0; i < nres; ++i) {
                p[i] = this.dft(ac, (double)i * (Math.PI * 2) / (double)res);
            }
            return new SmoothedPeriodogram(p, res);
        }

        private double dft(double[] ac, double freq) {
            double p = 1.0;
            for (int j = 1; j < this.winLen; ++j) {
                p += 2.0 * ac[j] * Math.cos((double)j * freq);
            }
            if (p < 0.0) {
                p = 0.0;
            }
            return p;
        }
    }
}

