/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixNorms;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.dk.DiffuseState;
import jdplus.toolkit.base.core.ssf.dk.DiffuseUpdateInformation;
import jdplus.toolkit.base.core.ssf.dk.IDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;

public class DurbinKoopmanInitializer
implements OrdinaryFilter.Initializer {
    private final IDiffuseFilteringResults results;
    private DiffuseState state;
    private DiffuseUpdateInformation pe;
    private ISsf ssf;
    private ISsfLoading loading;
    private ISsfError error;
    private ISsfDynamics dynamics;
    private ISsfData data;
    private double norm = 0.0;

    public DurbinKoopmanInitializer() {
        this.results = null;
    }

    public DurbinKoopmanInitializer(IDiffuseFilteringResults results) {
        this.results = results;
    }

    protected boolean error(int t) {
        double fi = this.loading.ZVZ(t, this.state.Pi());
        if (Math.abs(fi) < 1.0E-9) {
            fi = 0.0;
        }
        this.pe.setDiffuseVariance(fi);
        double f = this.loading.ZVZ(t, this.state.P());
        if (this.error != null) {
            f += this.error.at(t);
        }
        if (Math.abs(f) / this.norm < 1.0E-9) {
            f = 0.0;
        }
        this.pe.setVariance(f);
        double y = this.data.get(t);
        if (Double.isNaN(y)) {
            this.pe.setMissing();
            return false;
        }
        this.pe.set(y - this.loading.ZX(t, this.state.a()), this.data.isConstraint(t));
        this.loading.ZM(t, this.state.P(), this.pe.M());
        if (this.pe.isDiffuse()) {
            this.loading.ZM(t, this.state.Pi(), this.pe.Mi());
        }
        return true;
    }

    @Override
    public int initializeFilter(State fstate, ISsf ssf, ISsfData data) {
        if (!ssf.initialization().isDiffuse()) {
            ssf.initialization().a0(fstate.a());
            ssf.initialization().Pf0(fstate.P());
            return 0;
        }
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.data = data;
        if (!this.initState()) {
            return -1;
        }
        int t = 0;
        int end = data.length();
        while (t < end) {
            if (this.results != null) {
                this.results.save(t, this.state, StateInfo.Forecast);
            }
            if (this.error(t)) {
                if (this.results != null) {
                    this.results.save(t, this.pe);
                }
                this.update();
            } else if (this.results != null) {
                this.results.save(t, this.pe);
            }
            if (this.results != null) {
                this.results.save(t, this.state, StateInfo.Concurrent);
            }
            if (this.isZero(this.state.Pi())) break;
            this.state.next(t++, this.dynamics);
        }
        if (t >= end) {
            throw new SsfException("Diffuse initialization failed");
        }
        fstate.P().copy(this.state.P());
        fstate.a().copy(this.state.a());
        fstate.next(t++, this.dynamics);
        if (this.results != null) {
            this.results.close(t);
        }
        return t;
    }

    private boolean initState() {
        this.state = DiffuseState.of(this.ssf);
        if (this.state == null) {
            return false;
        }
        this.norm = MatrixNorms.frobeniusNorm(this.state.Pi());
        this.pe = new DiffuseUpdateInformation(this.ssf.getStateDim());
        return true;
    }

    private boolean isZero(FastMatrix P) {
        return P.isZero(1.0E-6 * this.norm);
    }

    private void update() {
        if (this.pe.isDiffuse()) {
            this.update1();
        } else {
            this.update0();
        }
    }

    private void update0() {
        double f = this.pe.getVariance();
        double e = this.pe.get();
        DataBlock C = this.pe.M();
        this.state.P().addXaXt(-1.0 / f, C);
        double c = e / f;
        this.state.a().addAY(c, C);
    }

    private void update1() {
        double f = this.pe.getVariance();
        double e = this.pe.get();
        double fi = this.pe.getDiffuseVariance();
        DataBlock C = this.pe.M();
        DataBlock Ci = this.pe.Mi();
        this.state.Pi().addXaXt(-1.0 / fi, Ci);
        this.state.P().addXaXt(-1.0 / f, C);
        DataBlock tmp = DataBlock.of((DoubleSeq)C);
        tmp.addAY(-f / fi, Ci);
        this.state.P().addXaXt(1.0 / f, tmp);
        this.state.a().addAY(e / fi, Ci);
    }
}

