/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.r;

import jdplus.sa.base.core.tests.CanovaHansen;
import jdplus.sa.base.core.tests.CanovaHansen2;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.sa.base.core.tests.FTest;
import jdplus.sa.base.core.tests.Friedman;
import jdplus.sa.base.core.tests.KruskalWallis;
import jdplus.sa.base.core.tests.ModifiedQs;
import jdplus.sa.base.core.tests.PeriodicLjungBox;
import jdplus.sa.base.core.tests.PeriodogramTest;
import jdplus.sa.base.core.tests.Qs;
import jdplus.sa.base.protobuf.SaProtosUtility;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import lombok.Generated;

public final class SeasonalityTests {
    public static StatisticalTest qsTest(double[] s, int period, int ny) {
        return SeasonalityTests.qsTest(s, period, ny, 1);
    }

    public static double modifiedQsTest(double[] s, int period, int ny) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        if (ny != 0) {
            y = y.drop(Math.max(0, y.length() - period * ny), 0);
        }
        return ModifiedQs.test((DoubleSeq)y, (int)period);
    }

    public static StatisticalTest qsTest(double[] s, int period, int ny, int type) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        if (ny != 0) {
            y = y.drop(Math.max(0, y.length() - period * ny), 0);
        }
        Qs qs = new Qs(y, period).autoCorrelationsCount(2);
        switch (type) {
            case 1: {
                qs.usePositiveAutocorrelations();
                break;
            }
            case -1: {
                qs.useNegativeAutocorrelations();
                break;
            }
            default: {
                qs.useAllAutocorrelations();
            }
        }
        return qs.build();
    }

    public static StatisticalTest kruskalWallisTest(double[] s, int period, int ny) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        if (ny != 0) {
            y = y.drop(Math.max(0, y.length() - period * ny), 0);
        }
        return new KruskalWallis(y, period).build();
    }

    public static StatisticalTest friedmanTest(double[] s, int period, int ny) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        if (ny != 0) {
            y = y.drop(Math.max(0, y.length() - period * ny), 0);
        }
        return new Friedman(y, period).build();
    }

    public static StatisticalTest periodogramTest(double[] s, int period, int ny) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        if (ny != 0) {
            y = y.drop(Math.max(0, y.length() - period * ny), 0);
        }
        return new PeriodogramTest(y, period).buildF();
    }

    public static StatisticalTest periodicQsTest(double[] s, double[] periods) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        return new PeriodicLjungBox(y, 0).lags(periods[0], 2).usePositiveAutocorrelations().build();
    }

    public static double[] canovaHansenTrigs(double[] s, double[] periods, boolean lag1, String kernel, int truncation, boolean original) {
        DoubleSeq x = DoubleSeq.of((double[])s).cleanExtremities();
        if (truncation < 0) {
            truncation = (int)Math.floor(0.75 * Math.sqrt(x.length()));
        }
        double[] rslt = new double[periods.length];
        for (int i = 0; i < periods.length; ++i) {
            double p = periods[i];
            rslt[i] = original ? CanovaHansen.test((DoubleSeq)x).specific(p, 1).lag1(lag1).windowFunction(WindowFunction.valueOf((String)kernel)).truncationLag(truncation).build().testAll() : CanovaHansen2.of((DoubleSeq)x).periodicity(p).lag1(lag1).windowFunction(WindowFunction.valueOf((String)kernel)).truncationLag(truncation).compute();
        }
        return rslt;
    }

    public static double[] canovaHansen(double[] s, int period, String type, boolean lag1, String kernel, int truncation, int start) {
        DoubleSeq x = DoubleSeq.of((double[])s).cleanExtremities();
        if (truncation < 0) {
            truncation = (int)Math.floor(0.75 * Math.sqrt(x.length()));
        }
        CanovaHansen.Builder builder = CanovaHansen.test((DoubleSeq)x).lag1(lag1).truncationLag(truncation).windowFunction(WindowFunction.valueOf((String)kernel)).startPosition(start);
        CanovaHansen.Variables vars = CanovaHansen.Variables.valueOf((String)type);
        if (null == vars) {
            return null;
        }
        switch (vars) {
            case Trigonometric: {
                CanovaHansen ch = builder.trigonometric(period).build();
                boolean even = period % 2 == 0;
                int p2 = period / 2;
                int nq = even ? p2 - 1 : p2;
                double[] q = new double[3 + p2];
                int icur = 0;
                int i = 0;
                while (i < nq) {
                    q[icur] = ch.test(i * 2, 2);
                    ++i;
                    ++icur;
                }
                if (even) {
                    q[icur++] = ch.test(period - 2);
                }
                q[icur++] = ch.testAll();
                StatisticalTest seasonalityTest = ch.seasonalityTest();
                q[icur++] = seasonalityTest.getValue();
                q[icur] = seasonalityTest.getPvalue();
                return q;
            }
            case Dummy: {
                CanovaHansen ch = builder.dummies(period).build();
                double[] q = new double[period + 3];
                for (int i = 0; i < period; ++i) {
                    q[i] = ch.test(i);
                }
                q[period] = ch.testAll();
                StatisticalTest seasonalityTest = ch.seasonalityTest();
                q[period + 1] = seasonalityTest.getValue();
                q[period + 2] = seasonalityTest.getPvalue();
                return q;
            }
        }
        CanovaHansen ch = builder.contrasts(period).build();
        double[] q = new double[period + 3];
        for (int i = 0; i < period - 1; ++i) {
            q[i] = ch.test(i);
        }
        q[period - 1] = ch.testDerived();
        q[period] = ch.testAll();
        StatisticalTest seasonalityTest = ch.seasonalityTest();
        q[period + 1] = seasonalityTest.getValue();
        q[period + 2] = seasonalityTest.getPvalue();
        return q;
    }

    public static StatisticalTest fTest(double[] s, int freq, String model, int ny) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        SarimaOrders.Prespecified M = SarimaOrders.Prespecified.valueOf((String)model);
        try {
            return new FTest(y, freq).model(M).ncycles(ny).build();
        }
        catch (Exception err) {
            return null;
        }
    }

    public static CombinedSeasonality combinedTest(double[] s, int period, int startperiod, boolean mul) {
        DoubleSeq y = DoubleSeq.of((double[])s).cleanExtremities();
        return new CombinedSeasonality(y, period, startperiod, mul ? 1.0 : 0.0);
    }

    public static byte[] toBuffer(CombinedSeasonality cs) {
        return SaProtosUtility.convert((CombinedSeasonality)cs).toByteArray();
    }

    @Generated
    private SeasonalityTests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

