/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5SLprivate_H
#define H5SLprivate_H

#include "H5private.h"

typedef struct H5SL_t      H5SL_t;
typedef struct H5SL_node_t H5SL_node_t;

typedef enum {
    H5SL_TYPE_INT,      
    H5SL_TYPE_HADDR,    
    H5SL_TYPE_STR,      
    H5SL_TYPE_HSIZE,    
    H5SL_TYPE_UNSIGNED, 
    H5SL_TYPE_SIZE,     
    H5SL_TYPE_OBJ,      
    H5SL_TYPE_HID,      
    H5SL_TYPE_GENERIC   
} H5SL_type_t;

typedef int (*H5SL_cmp_t)(const void *key1, const void *key2);

typedef herr_t (*H5SL_operator_t)(void *item, void *key, void *operator_data );

H5_DLL H5SL_t      *H5SL_create(H5SL_type_t type, H5SL_cmp_t cmp);
H5_DLL size_t       H5SL_count(H5SL_t *slist);
H5_DLL herr_t       H5SL_insert(H5SL_t *slist, void *item, const void *key);
H5_DLL H5SL_node_t *H5SL_add(H5SL_t *slist, void *item, const void *key);
H5_DLL void        *H5SL_remove(H5SL_t *slist, const void *key);
H5_DLL void        *H5SL_remove_first(H5SL_t *slist);
H5_DLL void        *H5SL_search(H5SL_t *slist, const void *key);
H5_DLL void        *H5SL_less(H5SL_t *slist, const void *key);
H5_DLL void        *H5SL_greater(H5SL_t *slist, const void *key);
H5_DLL H5SL_node_t *H5SL_find(H5SL_t *slist, const void *key);
H5_DLL H5SL_node_t *H5SL_below(H5SL_t *slist, const void *key);
H5_DLL H5SL_node_t *H5SL_above(H5SL_t *slist, const void *key);
H5_DLL H5SL_node_t *H5SL_first(H5SL_t *slist);
H5_DLL H5SL_node_t *H5SL_next(H5SL_node_t *slist_node);
H5_DLL H5SL_node_t *H5SL_prev(H5SL_node_t *slist_node);
H5_DLL H5SL_node_t *H5SL_last(H5SL_t *slist);
H5_DLL void        *H5SL_item(H5SL_node_t *slist_node);
H5_DLL herr_t       H5SL_iterate(H5SL_t *slist, H5SL_operator_t op, void *op_data);
H5_DLL herr_t       H5SL_release(H5SL_t *slist);
H5_DLL herr_t       H5SL_free(H5SL_t *slist, H5SL_operator_t op, void *op_data);
H5_DLL herr_t       H5SL_close(H5SL_t *slist);
H5_DLL herr_t       H5SL_destroy(H5SL_t *slist, H5SL_operator_t op, void *op_data);
H5_DLL int          H5SL_term_interface(void);

#endif 
