/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import java.util.Formatter;
import java.util.Locale;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class LikelihoodStatistics {
    private int observationsCount;
    private int effectiveObservationsCount;
    private int estimatedParametersCount;
    private double logLikelihood;
    private double transformationAdjustment;
    private double adjustedLogLikelihood;
    private double ssqErr;
    private double AIC;
    private double AICC;
    private double BIC;
    private double BICC;
    private double BIC2;
    private double HannanQuinn;

    public static Builder statistics(double ll, int nobs) {
        return new Builder(ll, nobs);
    }

    private void calc() {
        double n = this.effectiveObservationsCount;
        double np = this.estimatedParametersCount;
        double ll = this.adjustedLogLikelihood;
        double nll = this.logLikelihood;
        this.AIC = -2.0 * (ll - np);
        this.HannanQuinn = -2.0 * (ll - np * Math.log(Math.log(n)));
        this.AICC = -2.0 * (ll - n * np / (n - np - 1.0));
        this.BIC = -2.0 * ll + np * Math.log(n);
        this.BIC2 = (-2.0 * nll + np * Math.log(n)) / n;
        if (this.ssqErr != 0.0) {
            this.BICC = Math.log(this.ssqErr / n) + (np - 1.0) * Math.log(n) / n;
        } else {
            this.ssqErr = Double.NaN;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Number of observations :").append(this.observationsCount).append(System.lineSeparator());
        if (this.effectiveObservationsCount != this.observationsCount) {
            builder.append("Effective number of observations :").append(this.effectiveObservationsCount).append(System.lineSeparator());
        }
        if (this.estimatedParametersCount != 0) {
            builder.append("Number of parameters estimated :").append(this.estimatedParametersCount).append(System.lineSeparator());
        }
        Formatter fmt = new Formatter(Locale.ROOT);
        builder.append("log likelihood :").append(fmt.format("%.4f", this.logLikelihood)).append(System.lineSeparator());
        if (this.transformationAdjustment != 0.0) {
            fmt = new Formatter(Locale.ROOT);
            builder.append("Transformation Adjustment :").append(fmt.format("%.4f", this.transformationAdjustment)).append(System.lineSeparator());
            fmt = new Formatter(Locale.ROOT);
            builder.append("Adjusted log likelihood :").append(fmt.format("%.4f", this.adjustedLogLikelihood)).append(System.lineSeparator());
        }
        fmt = new Formatter(Locale.ROOT);
        builder.append("AIC :").append(fmt.format("%.4f", this.AIC)).append(System.lineSeparator());
        fmt = new Formatter(Locale.ROOT);
        builder.append("BIC :").append(fmt.format("%.4f", this.BIC)).append(System.lineSeparator());
        fmt = new Formatter(Locale.ROOT);
        if (Double.isFinite(this.ssqErr)) {
            builder.append("BIC corrected for length :").append(fmt.format("%.4f", this.BICC));
        }
        return builder.toString();
    }

    @Generated
    public LikelihoodStatistics() {
    }

    @Generated
    public void setObservationsCount(int observationsCount) {
        this.observationsCount = observationsCount;
    }

    @Generated
    public void setEffectiveObservationsCount(int effectiveObservationsCount) {
        this.effectiveObservationsCount = effectiveObservationsCount;
    }

    @Generated
    public void setEstimatedParametersCount(int estimatedParametersCount) {
        this.estimatedParametersCount = estimatedParametersCount;
    }

    @Generated
    public void setLogLikelihood(double logLikelihood) {
        this.logLikelihood = logLikelihood;
    }

    @Generated
    public void setTransformationAdjustment(double transformationAdjustment) {
        this.transformationAdjustment = transformationAdjustment;
    }

    @Generated
    public void setAdjustedLogLikelihood(double adjustedLogLikelihood) {
        this.adjustedLogLikelihood = adjustedLogLikelihood;
    }

    @Generated
    public void setSsqErr(double ssqErr) {
        this.ssqErr = ssqErr;
    }

    @Generated
    public void setAIC(double AIC) {
        this.AIC = AIC;
    }

    @Generated
    public void setAICC(double AICC) {
        this.AICC = AICC;
    }

    @Generated
    public void setBIC(double BIC) {
        this.BIC = BIC;
    }

    @Generated
    public void setBICC(double BICC) {
        this.BICC = BICC;
    }

    @Generated
    public void setBIC2(double BIC2) {
        this.BIC2 = BIC2;
    }

    @Generated
    public void setHannanQuinn(double HannanQuinn) {
        this.HannanQuinn = HannanQuinn;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LikelihoodStatistics)) {
            return false;
        }
        LikelihoodStatistics other = (LikelihoodStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getObservationsCount() != other.getObservationsCount()) {
            return false;
        }
        if (this.getEffectiveObservationsCount() != other.getEffectiveObservationsCount()) {
            return false;
        }
        if (this.getEstimatedParametersCount() != other.getEstimatedParametersCount()) {
            return false;
        }
        if (Double.compare(this.getLogLikelihood(), other.getLogLikelihood()) != 0) {
            return false;
        }
        if (Double.compare(this.getTransformationAdjustment(), other.getTransformationAdjustment()) != 0) {
            return false;
        }
        if (Double.compare(this.getAdjustedLogLikelihood(), other.getAdjustedLogLikelihood()) != 0) {
            return false;
        }
        if (Double.compare(this.getSsqErr(), other.getSsqErr()) != 0) {
            return false;
        }
        if (Double.compare(this.getAIC(), other.getAIC()) != 0) {
            return false;
        }
        if (Double.compare(this.getAICC(), other.getAICC()) != 0) {
            return false;
        }
        if (Double.compare(this.getBIC(), other.getBIC()) != 0) {
            return false;
        }
        if (Double.compare(this.getBICC(), other.getBICC()) != 0) {
            return false;
        }
        if (Double.compare(this.getBIC2(), other.getBIC2()) != 0) {
            return false;
        }
        return Double.compare(this.getHannanQuinn(), other.getHannanQuinn()) == 0;
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof LikelihoodStatistics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getObservationsCount();
        result = result * 59 + this.getEffectiveObservationsCount();
        result = result * 59 + this.getEstimatedParametersCount();
        long $logLikelihood = Double.doubleToLongBits(this.getLogLikelihood());
        result = result * 59 + (int)($logLikelihood >>> 32 ^ $logLikelihood);
        long $transformationAdjustment = Double.doubleToLongBits(this.getTransformationAdjustment());
        result = result * 59 + (int)($transformationAdjustment >>> 32 ^ $transformationAdjustment);
        long $adjustedLogLikelihood = Double.doubleToLongBits(this.getAdjustedLogLikelihood());
        result = result * 59 + (int)($adjustedLogLikelihood >>> 32 ^ $adjustedLogLikelihood);
        long $ssqErr = Double.doubleToLongBits(this.getSsqErr());
        result = result * 59 + (int)($ssqErr >>> 32 ^ $ssqErr);
        long $AIC = Double.doubleToLongBits(this.getAIC());
        result = result * 59 + (int)($AIC >>> 32 ^ $AIC);
        long $AICC = Double.doubleToLongBits(this.getAICC());
        result = result * 59 + (int)($AICC >>> 32 ^ $AICC);
        long $BIC = Double.doubleToLongBits(this.getBIC());
        result = result * 59 + (int)($BIC >>> 32 ^ $BIC);
        long $BICC = Double.doubleToLongBits(this.getBICC());
        result = result * 59 + (int)($BICC >>> 32 ^ $BICC);
        long $BIC2 = Double.doubleToLongBits(this.getBIC2());
        result = result * 59 + (int)($BIC2 >>> 32 ^ $BIC2);
        long $HannanQuinn = Double.doubleToLongBits(this.getHannanQuinn());
        result = result * 59 + (int)($HannanQuinn >>> 32 ^ $HannanQuinn);
        return result;
    }

    @Generated
    public int getObservationsCount() {
        return this.observationsCount;
    }

    @Generated
    public int getEffectiveObservationsCount() {
        return this.effectiveObservationsCount;
    }

    @Generated
    public int getEstimatedParametersCount() {
        return this.estimatedParametersCount;
    }

    @Generated
    public double getLogLikelihood() {
        return this.logLikelihood;
    }

    @Generated
    public double getTransformationAdjustment() {
        return this.transformationAdjustment;
    }

    @Generated
    public double getAdjustedLogLikelihood() {
        return this.adjustedLogLikelihood;
    }

    @Generated
    public double getSsqErr() {
        return this.ssqErr;
    }

    @Generated
    public double getAIC() {
        return this.AIC;
    }

    @Generated
    public double getAICC() {
        return this.AICC;
    }

    @Generated
    public double getBIC() {
        return this.BIC;
    }

    @Generated
    public double getBICC() {
        return this.BICC;
    }

    @Generated
    public double getBIC2() {
        return this.BIC2;
    }

    @Generated
    public double getHannanQuinn() {
        return this.HannanQuinn;
    }

    public static class Builder {
        private final int nobs;
        private final double ll;
        private int neffective;
        private int nparams;
        private double adj;
        private double ssqerr;

        private Builder(double ll, int nobs) {
            this.ll = ll;
            this.nobs = nobs;
            this.neffective = nobs;
        }

        public Builder differencingOrder(int ndiff) {
            this.neffective -= ndiff;
            return this;
        }

        public Builder diffuseOrder(int ndiff) {
            this.neffective -= ndiff;
            return this;
        }

        public Builder llAdjustment(double adj) {
            this.adj = adj;
            return this;
        }

        public Builder ssq(double ssqerr) {
            this.ssqerr = ssqerr;
            return this;
        }

        public Builder parametersCount(int nparams) {
            this.nparams = nparams;
            return this;
        }

        public LikelihoodStatistics build() {
            LikelihoodStatistics stats = new LikelihoodStatistics();
            stats.observationsCount = this.nobs;
            stats.effectiveObservationsCount = this.neffective;
            stats.logLikelihood = this.ll;
            stats.estimatedParametersCount = this.nparams;
            if (Double.isNaN(this.adj)) {
                this.adj = 0.0;
            }
            stats.transformationAdjustment = this.adj;
            stats.adjustedLogLikelihood = this.adj == 0.0 ? stats.logLikelihood : stats.logLikelihood + stats.transformationAdjustment;
            stats.ssqErr = this.ssqerr;
            stats.calc();
            return stats;
        }
    }
}

