/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.seats.DefaultModelEstimator;
import jdplus.tramoseats.base.core.seats.IModelApproximator;
import jdplus.tramoseats.base.core.seats.IModelEstimator;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class DefaultModelApproximator
implements IModelApproximator {
    private final IModelEstimator estimator;
    private static final double DEF_RMODP = 0.7;
    private final double rmodp_ = 0.7;
    private int originalDifferencing;

    public DefaultModelApproximator(IModelEstimator estimator) {
        this.estimator = estimator == null ? new DefaultModelEstimator(null, null) : estimator;
    }

    @Override
    public boolean approximate(SeatsModel sm) {
        SarimaOrders spec = sm.getCurrentModel().orders();
        this.originalDifferencing = spec.getD() + spec.getBd();
        if (this.app_known(sm)) {
            return true;
        }
        if (this.app_seas(sm)) {
            return true;
        }
        if (this.app_redp(sm)) {
            return true;
        }
        if (this.app_redq(sm)) {
            return true;
        }
        return this.app_last(sm);
    }

    private boolean app_seas(SeatsModel sm) {
        SarimaModel cur = sm.getCurrentModel();
        SarimaOrders spec = cur.orders();
        boolean mean = sm.isMeanCorrection();
        int p = spec.getP();
        int d = spec.getD();
        int q = spec.getQ();
        int bp = spec.getBp();
        int bd = spec.getBd();
        int bq = spec.getBq();
        if (bd == 1 && bp == 1) {
            spec.setBp(0);
            spec.setBq(1);
        } else if (bd == 0 && bq == 1) {
            double bth = cur.btheta(1);
            if (bp == 0) {
                if (bth > 0.0) {
                    spec.setBp(1);
                }
                spec.setBq(0);
            } else {
                double bphi = cur.bphi(1);
                if (bphi < -0.7 && bth > 0.0) {
                    spec.setBd(1);
                    spec.setBp(0);
                    mean = false;
                } else {
                    spec.setBq(0);
                }
            }
        } else if (bp == 1 && bd == 0 && bq == 0) {
            if (p == 0 && d == 1 && q > 1) {
                spec.setQ(q - 1);
            } else if (cur.bphi(1) < -0.3 && sm.isSignificantSeasonality()) {
                spec.setBp(0);
                spec.setBd(1);
                spec.setBq(1);
                mean = false;
            } else {
                spec.setBp(0);
            }
        } else {
            return false;
        }
        sm.setMeanCorrection(mean);
        return this.estimateModel(sm, spec);
    }

    private boolean app_redp(SeatsModel sm) {
        SarimaModel cur = sm.getCurrentModel();
        SarimaOrders spec = cur.orders();
        if (spec.getP() == 0) {
            return false;
        }
        double rdroot = 0.0;
        Complex[] proots = cur.getRegularAR().roots();
        for (int i = 0; i < proots.length; ++i) {
            double re = proots[i].getRe();
            double im = proots[i].getIm();
            if (im != 0.0 || !(re > 0.0) || !((re = 1.0 / re) > rdroot)) continue;
            rdroot = re;
        }
        spec.setP(spec.getP() - 1);
        if (rdroot > 0.5) {
            spec.setD(Math.min(spec.getD() + 1, 2));
            if (spec.getBd() + spec.getD() > this.originalDifferencing) {
                sm.setMeanCorrection(false);
            }
        }
        int q = spec.getQ();
        q = Math.min(q + 1, spec.getD() + spec.getP());
        spec.setQ(Math.min(q, 3));
        return this.estimateModel(sm, spec);
    }

    private boolean app_redq(SeatsModel sm) {
        SarimaModel cur = sm.getCurrentModel();
        SarimaOrders spec = cur.orders();
        if (spec.getQ() == 1) {
            return false;
        }
        spec.setQ(Math.max(spec.getQ() - 1, 1));
        return this.estimateModel(sm, spec);
    }

    private boolean app_last(SeatsModel sm) {
        SarimaModel cur = sm.getCurrentModel();
        SarimaOrders spec = cur.orders();
        spec.setBq(0);
        return this.estimateModel(sm, spec);
    }

    private boolean app_known(SeatsModel sm) {
        SarimaModel cur = sm.getCurrentModel();
        SarimaOrders spec = cur.orders();
        int p = spec.getP();
        int d = spec.getD();
        int q = spec.getQ();
        int bp = spec.getBp();
        int bd = spec.getBd();
        int bq = spec.getBq();
        if (bp != 0 || bd != 1 || q > 1 || p != 0) {
            return false;
        }
        switch (d) {
            case 0: {
                return this.app_001011(sm, cur, spec);
            }
            case 2: {
                return this.app_021011(sm, cur, spec);
            }
        }
        return this.app_011011(sm, cur, spec);
    }

    private boolean app_001011(SeatsModel sm, SarimaModel cur, SarimaOrders spec) {
        sm.setCurrentModel(cur.toBuilder().btheta(1, 0.0).adjustOrders(true).build());
        return true;
    }

    private boolean app_011011(SeatsModel sm, SarimaModel cur, SarimaOrders spec) {
        double th = spec.getQ() == 1 ? -cur.theta(1) : 0.0;
        double bth = switch (spec.getPeriod()) {
            case 12 -> {
                if (th > 0.36 && th < 0.7) {
                    yield 0.2;
                }
                yield 0.1;
            }
            case 4 -> {
                if (th < 0.2 && th >= 0.0) {
                    yield -0.3;
                }
                if (th < 0.0 && th > -0.2) {
                    yield -0.24;
                }
                if (Math.abs(th) > 0.4) {
                    yield -0.1;
                }
                yield -0.2;
            }
            default -> 0.0;
        };
        spec.setQ(th == 0.0 ? 0 : 1);
        spec.setBq(bth == 0.0 ? 0 : 1);
        SarimaModel.Builder builder = SarimaModel.builder((SarimaOrders)spec);
        if (th != 0.0) {
            builder.theta(1, -th);
        }
        if (bth != 0.0) {
            builder.btheta(1, -bth);
        }
        sm.setCurrentModel(builder.build());
        return true;
    }

    private boolean app_021011(SeatsModel sm, SarimaModel cur, SarimaOrders spec) {
        double th = spec.getQ() == 1 ? -cur.theta(1) : 0.0;
        double bth = spec.getBq() == 1 ? -cur.btheta(1) : 0.0;
        switch (spec.getPeriod()) {
            case 12: {
                if (th < -0.4) {
                    th = -0.5;
                    bth = 0.9;
                    break;
                }
                if (th < 0.25) {
                    bth = (4.95 - 4.0 * th) / 7.0;
                    break;
                }
                if (th < 0.55) {
                    if (bth >= -0.3) {
                        bth = -3.2 * th + 1.55;
                        break;
                    }
                    th = 0.55;
                    bth = -0.3;
                    break;
                }
                bth = (th - 1.15) / 2.0;
                break;
            }
            case 4: {
                if (th >= -0.4) {
                    bth = -0.3;
                    break;
                }
                if (bth < -0.3) {
                    th = -0.4;
                    bth = -0.3;
                    break;
                }
                th = -0.45 * bth - 0.535;
                break;
            }
            case 6: {
                if (th >= 0.1) {
                    bth = -0.2;
                    break;
                }
                if (bth < -0.3) {
                    bth = -0.3;
                    th = 0.1;
                    break;
                }
                if (th > -0.3) {
                    bth = -1.5 * th - 0.05;
                    break;
                }
                if (th >= -0.9) {
                    bth = -th - 0.05;
                    break;
                }
                bth = 0.95;
                th = -0.9;
                break;
            }
            case 3: {
                if (th > 0.55) {
                    bth = -0.1;
                    break;
                }
                if (bth < -0.3) {
                    th = 0.55;
                    bth = -0.3;
                    break;
                }
                if (th > -0.4) {
                    if (bth < 0.0) {
                        th = 0.55;
                        break;
                    }
                    if (bth < 0.7) {
                        th = -0.5 * bth + 0.55;
                        break;
                    }
                    th = -3.21 * bth + 2.45;
                    break;
                }
                if (th > -0.7) {
                    bth = 0.95;
                    break;
                }
                bth = 0.95;
                th = -0.7;
                break;
            }
            case 2: {
                bth = th >= 0.4 ? -0.3 : 0.48 * th - 0.49;
            }
        }
        boolean hasq = Math.abs(th) > 1.0E-10;
        boolean hasbq = Math.abs(bth) > 1.0E-10;
        spec.setQ(hasq ? 1 : 0);
        spec.setBq(hasbq ? 1 : 0);
        SarimaModel.Builder builder = SarimaModel.builder((SarimaOrders)spec);
        if (hasq) {
            builder.theta(1, -th);
        }
        if (hasbq) {
            builder.btheta(1, -bth);
        }
        sm.setCurrentModel(builder.build());
        return true;
    }

    private boolean estimateModel(SeatsModel sm, SarimaOrders spec) {
        sm.setCurrentModel(SarimaModel.builder((SarimaOrders)spec).setDefault().build());
        return this.estimator.estimate(sm);
    }
}

