## Bayesian Estimation of Probit Unfolding Models

### Description

**pumBayes** is an R package designed for Bayesian estimation of probit unfolding models (PUM) for binary preference data. The package is publicly available and can be cited using the following DOI: [10.5281/zenodo.18533211](https://doi.org/10.5281/zenodo.18533211).

### Before installing

The package requires a working installation of **R (version ≥ 3.6.0)**.

If you do not yet have R installed, download it from:
https://cran.r-project.org/

Most users run R through **RStudio**, a graphical interface for R.  
RStudio can be downloaded from:
https://posit.co/download/rstudio-desktop/

In RStudio, packages can be installed either by running commands in the Console
or by using the *Packages → Install* button in the top-right panel.

### Installation

You can install the stable version of **pumBayes** from CRAN:

```r
install.packages("pumBayes")
library(pumBayes)
```

Or install the development version from GitHub:

```R
install.packages("devtools")
library(devtools)
install_github("SkylarShiHub/pumBayes")
library(pumBayes)
```

### Documentation

CRAN page: https://cran.r-project.org/package=pumBayes

### Support and Contact

For bug reports and feature requests, please open an issue on GitHub:

https://github.com/SkylarShiHub/pumBayes/issues

For general questions about the methodology or the software, you may contact the authors:

- **Skylar Shi** — dshi98@uw.edu  
- **Abel Rodríguez** — abelr@uw.edu  
- **Rayleigh Lei** — rayleigh@umich.edu


