## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE, # prevents code from appearing in knit but not results
  collapse = TRUE, # separates code and output are separated into different chunks?
  comment = "#>" # I think this determines the text at the start of a line
)
#load("../data/LBP.rda")
#devtools::load_all()
library(wlsd)

## ----long-tab, echo = FALSE, results = "asis"---------------------------------
knitr::kable(long_data, caption = "Long Format Data", label = "long-tab")

## ----cp-tab, echo = FALSE, results = "asis"-----------------------------------
knitr::kable(cp_data, caption = "Counting Process Format")

## ----transition_graphic, echo=FALSE, out.width="50%", fig.cap="Format transitions for wlsd."----
knitr::include_graphics("../man/figures/wlsd-format-drawing.png")

## ----long2cp------------------------------------------------------------------
long2cp(data = long_data, id = "id", time = "time", status = "event")

## ----long2cp no drop----------------------------------------------------------
dropped_long <- long_data[1:8,]
long2cp(dropped_long, id = "id", time = "time", status = "event", drop = "FALSE")

## ----long2cp drop-------------------------------------------------------------
long2cp(dropped_long, id = "id", time = "time", status = "event", drop = "TRUE")

## ----cp2long------------------------------------------------------------------
cp2long(data = cp_data, id = "id", time1 = "time1", time2 = "time2", status = "event")

## ----cp2long fill-------------------------------------------------------------
cp2long(cp_data, id = "id", time1 = "time1", time2 = "time2", status = "event", fill = TRUE)

## ----long2count---------------------------------------------------------------
long2count(long_data, id = "id", event = "event")

## ----long2count fun-----------------------------------------------------------
long2count(long_data, id = "id", event = "event", FUN = max)

## ----long2count events--------------------------------------------------------
long_data2 <- long_data
long_data2$event2 <- c(2,2,3,1,2,3,2,1,3)
long2count(long_data2, id = "id", event = c("event","event2"))

## ----long2count state---------------------------------------------------------
long2count(long_data, id = "id", state = "event")

## ----LBP head-----------------------------------------------------------------
LBP[1:5,1:10]

## ----baseline-----------------------------------------------------------------
LBPwBaseline <- basedate(LBP, "sid")
LBPwBaseline[1:5,1:10]

## ----update baseline----------------------------------------------------------
LBPwBaseline$Date <- ifelse(is.na(LBPwBaseline$Date), LBPwBaseline$Baseline.date, LBPwBaseline$Date)
LBPwBaseline[is.na(LBPwBaseline)] <- 0

## ----0 example----------------------------------------------------------------
LBPwBaseline[404:406,1:8]

## ----case progression---------------------------------------------------------
LBPwBaseline$case.lbp <- ifelse(LBPwBaseline$case.lbp == 0 &
                               (LBPwBaseline$case.med == 1 | 
                                LBPwBaseline$case.sc == 1 | 
                                LBPwBaseline$case.lt == 1),
                                1, 
                                LBPwBaseline$case.lbp)
LBPwBaseline[404:406,1:8]

## ----events2state-------------------------------------------------------------
LBP_msm <- events2state(LBPwBaseline, events = c("case.lbp",
                                                 "case.med",
                                                 "case.sc",
                                                 "case.lt"))

## ----LBP cp-------------------------------------------------------------------
LBP_cp <- long2cp(LBPwBaseline, id = "sid", time = "time_to_row", status = c("case.lbp", "case.med", "case.sc", "case.lt"))
LBP_cp[1:5,1:10]

## ----takefirst----------------------------------------------------------------
LBP_cp2 <- takefirst(LBP_cp, id = "sid",
                     criteria.column = "case.lbp",
                     criteria = 1)

LBP_cp2[11:14,1:8]

## ----LBP count----------------------------------------------------------------
LBP_count <- long2count(LBPwBaseline, "sid", event = c("case.lbp",
                                                 "case.med",
                                                 "case.sc",
                                                 "case.lt"))

LBP_count[1:5,c(1,20:24)]

## ----LBP state----------------------------------------------------------------
LBP_state <- long2count(LBP_msm, "sid", state = "state", FUN = sum)
LBP_state[1:9,c(1,5:8,24:26)]

