## ----setup, include=FALSE-----------------------------------------------------
# setupKnitr()
# knitr::opts_chunk$set(echo = TRUE,
#                       fig.align = "center",
#                       warning = FALSE,
#                       webgl = TRUE,
#                       fig.width = 8, 
#                       fig.height = 8,
#                       fig.keep = "all",
#                       fig.ext = "jpeg"
#                       )

## ----fig.width=5, fig.height=5------------------------------------------------
library(PDEnaiveBayes)

data(Hepta)
Data = Hepta$Data
Cls = Hepta$Cls

## ----fig.width=5, fig.height=5------------------------------------------------

model = Train_naiveBayes(Data, 
                          Cls, 
                          Gaussian = FALSE, 
                          Plausible = FALSE)
table(Cls, model$ClsTrain)


## ----fig.width=5, fig.height=5, eval = FALSE----------------------------------
# 
# if (requireNamespace("parallel")) {
# 
#   library(parallel)
# 
#   train_index = sample(1:nrow(Data), 0.8 * nrow(Data))
# 
#   train_data = Data[train_index, ]
#   test_data = Data[-train_index, ]
#   train_cls = Cls[train_index]
#   test_cls = Cls[-train_index]
# 
#   num_cores = detectCores() - 1
#   cl = makeCluster(num_cores)
#   if (requireNamespace("FCPS")) {
#     data(Hepta)
#     Data = Hepta$Data
#     Cls  = Hepta$Cls
#     model_mc = Train_naiveBayes_multicore(
#       cl       = cl,
#       Data     = train_data,
#       Cls      = train_cls,
#       Predict  = TRUE
#     )
#     table(train_cls, model_mc$ClsTrain)
#   }
# }

## ----fig.width=5, fig.height=5, eval=FALSE------------------------------------
# preds = Predict_naiveBayes(test_data, model_mc)
# table(test_cls, preds$Cls)

## ----fig.width=5, fig.height=5------------------------------------------------
PlotLikelihoodFuns(
  LikelihoodFuns = model$Model$PDFs_funs,
  Data        = Hepta$Data
)

## ----fig.width=5, fig.height=5, eval = FALSE----------------------------------
# # CRAN does not allow interactive plotly plots, hence the plot is given as a static image
# PlotNaiveBayes(Model = model$Model, FeatureNames = colnames(Hepta$Data))

## ----fig.width=5, fig.height=5------------------------------------------------
PlotBayesianDecision2D(
  X          = Hepta$Data[, 1],
  Y          = Hepta$Data[, 2],
  Posteriors = model$Posteriors,
  Class      = 2,
  xlab = "X1",
  ylab = "X2"
)

## ----fig.width=5, fig.height=5------------------------------------------------
PlotPosteriors(
  Data       = Data,
  Posteriors = model$Posteriors,
  Class      = 2)

## ----fig.width=5, fig.height=5------------------------------------------------

x1 = rnorm(1000,0,2)
x2 = rnorm(1000,5,5.5)
x = c(x1, x2)

f1 = dnorm(x, 0, 2)
f2 = dnorm(x, 5, 5.5)
p1 = f1 / (f1 + f2)
comp = rbinom(2000, 1, p1) + 1

model_1d = Train_naiveBayes(as.matrix(x), 
                          comp, 
                          Gaussian = FALSE, 
                          Plausible = TRUE,
                          PlotIt = TRUE)


