api <- hal_query()

hal <- hal_facet(api, field = "keyword_s", prefix = "A")
expect_identical(hal$facet, "true")
expect_identical(hal$facet.field, "keyword_s")
expect_identical(hal$facet.limit, 5)
expect_identical(hal$facet.sort, "count")
expect_identical(hal$facet.prefix, "A")

## Contains
hal <- hal_facet(api, field = "authLastNameFirstName_s", contains = "Ernst")
expect_identical(hal$facet.contains, "Ernst")
expect_identical(hal$facet.contains.ignoreCase, "false")

## Pivot
hal <- hal_facet(api, pivot = c("docType_s", "submitType_s"))
expect_identical(hal$facet.pivot, "docType_s,submitType_s")

## Range
hal <- hal_facet(api, range = list(field = "submittedDateY_i", start = 1990, end = 2010, gap = 2))
expect_identical(hal$facet.range, "submittedDateY_i")
expect_identical(hal$facet.range.start, 1990)
expect_identical(hal$facet.range.end, 2010)
expect_identical(hal$facet.range.gap, 2)

## Prevent grouping and faceting
hal <- hal_group(api, field = "docType_s", limit = 20)
expect_identical(hal$group, "true")
hal <- hal_facet(hal, field = "keyword_s")
expect_identical(hal$group, "false")
