[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

EpiNow2 is an R package for estimating the time-varying reproduction number, growth rate, and doubling time from right truncated data.

The package uses Stan for the core modelling and R for pre-processing and post-processing of inputs and outputs.

This website covers the documentation of the Stan code/functions (See the next tab).

## Documentation structure

The documentation is organized by function groups, with related functions grouped together:

Each function page includes:

- A brief description of the function's purpose
- Detailed explanation of the function's behavior
- Parameter descriptions
- Return value information
- Call and caller graphs
- Collaboration graphs
- Referencing and referenced functions

## EpiNow2 main website

Click [here](https://epiforecasts.github.io/EpiNow2/) to return to the main EpiNow2 website.