% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_key_functions.R
\name{get_api_key}
\alias{get_api_key}
\title{Get API key from R environment variable.}
\usage{
get_api_key(env_var = "CHATGPT_KEY")
}
\arguments{
\item{env_var}{Character string indicating the name of the temporary R environment variable with
the API key and the used AI model. Currently, the argument only takes \code{env_var = "CHATGPT_KEY"}.
See \code{\link[=set_api_key]{set_api_key()}} to set/create this variable.}
}
\value{
The specified API key (NOTE: Avoid exposing this in the console).
}
\description{
Get API key from R environment variable.
}
\details{
\code{get_api_key()} can be used after executing \code{\link[=set_api_key]{set_api_key()}} or by adding the
api key permanently to your R environment by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}.
Then write \verb{CHATGPT_KEY=[insert your api key here]} and close the \code{.Renviron} window and restart R.
}
\note{
Find your personal API key at \url{https://platform.openai.com/account/api-keys}.
}
\examples{
\dontrun{
get_api_key()
}
}
\seealso{
\code{\link{set_api_key}}.
}
