% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_isolates}
\alias{example_isolates}
\title{Data Set with 2 000 Example Isolates}
\format{
A \link[tibble:tibble]{tibble} with 2 000 observations and 46 variables:
\itemize{
\item \code{date}\cr Date of receipt at the laboratory
\item \code{patient}\cr ID of the patient
\item \code{age}\cr Age of the patient
\item \code{gender}\cr Gender of the patient, either "F" or "M"
\item \code{ward}\cr Ward type where the patient was admitted, either "Clinical", "ICU", or "Outpatient"
\item \code{mo}\cr ID of microorganism created with \code{\link[=as.mo]{as.mo()}}, see also the \link{microorganisms} data set
\item \code{PEN:RIF}\cr 40 different antibiotics with class \code{\link{sir}} (see \code{\link[=as.sir]{as.sir()}}); these column names occur in the \link{antibiotics} data set and can be translated with \code{\link[=set_ab_names]{set_ab_names()}} or \code{\link[=ab_name]{ab_name()}}
}
}
\usage{
example_isolates
}
\description{
A data set containing 2 000 microbial isolates with their full antibiograms. This data set contains randomised fictitious data, but reflects reality and can be used to practise AMR data analysis. For examples, please read \href{https://msberends.github.io/AMR/articles/AMR.html}{the tutorial on our website}.
}
\details{
Like all data sets in this package, this data set is publicly available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.
}
\examples{
example_isolates
}
\keyword{datasets}
