% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\docType{data}
\name{as.disk}
\alias{as.disk}
\alias{disk}
\alias{NA_disk_}
\alias{is.disk}
\title{Transform Input to Disk Diffusion Diameters}
\format{
An object of class \code{disk} (inherits from \code{integer}) of length 1.
}
\usage{
as.disk(x, na.rm = FALSE)

NA_disk_

is.disk(x)
}
\arguments{
\item{x}{Vector.}

\item{na.rm}{A \link{logical} indicating whether missing values should be removed.}
}
\value{
An \link{integer} with additional class \code{\link{disk}}
}
\description{
This transforms a vector to a new class \code{\link{disk}}, which is a disk diffusion growth zone size (around an antibiotic disk) in millimetres between 0 and 50.
}
\details{
Interpret disk values as SIR values with \code{\link[=as.sir]{as.sir()}}. It supports guidelines from EUCAST and CLSI.

Disk diffusion growth zone sizes must be between 0 and 50 millimetres. Values higher than 50 but lower than 100 will be maximised to 50. All others input values outside the 0-50 range will return \code{NA}.

\code{NA_disk_} is a missing value of the new \code{disk} class.
}
\examples{
# transform existing disk zones to the `disk` class (using base R)
df <- data.frame(
  microorganism = "Escherichia coli",
  AMP = 20,
  CIP = 14,
  GEN = 18,
  TOB = 16
)
df[, 2:5] <- lapply(df[, 2:5], as.disk)
str(df)

\donttest{
# transforming is easier with dplyr:
if (require("dplyr")) {
  df \%>\% mutate(across(AMP:TOB, as.disk))
}
}

# interpret disk values, see ?as.sir
as.sir(
  x = as.disk(18),
  mo = "Strep pneu", # `mo` will be coerced with as.mo()
  ab = "ampicillin", # and `ab` with as.ab()
  guideline = "EUCAST"
)

# interpret whole data set, pretend to be all from urinary tract infections:
as.sir(df, uti = TRUE)
}
\seealso{
\code{\link[=as.sir]{as.sir()}}
}
\keyword{datasets}
