% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kinship_pca.R
\name{kinship.pca}
\alias{kinship.pca}
\title{Performs a Principal Component Analysis (PCA) based on a kinship matrix K}
\usage{
kinship.pca(
  K = NULL,
  scale = TRUE,
  label = FALSE,
  ncp = 10,
  groups = NULL,
  ellipses = FALSE
)
}
\arguments{
\item{K}{Input of a kinship matrix in full form (\eqn{n \times n}) (default = \code{NULL}).}

\item{scale}{If \code{TRUE} the PCA analysis will scale the kinship matrix, otherwise
it is used in its original scale (default = \code{TRUE}).}

\item{label}{If \code{TRUE} then includes in output individuals names (default = \code{FALSE}).}

\item{ncp}{The number of PC dimensions to be shown in the screeplot, and to provide
in the output data frame (default = \code{10}).}

\item{groups}{Specifies a vector of class factor that will be used to define different
colors for individuals in the PCA plot. It must be presented in the same order as the individuals
in the kinship matrix (default = \code{NULL}).}

\item{ellipses}{If \code{TRUE}, ellipses will will be drawn around each of the define levels in
\code{groups} (default = \code{FALSE}).}
}
\value{
A list with the following four elements:
\itemize{
\item{\code{eigenvalues}: a data frame with the eigenvalues and its variances associated with each dimension
including only the first \code{ncp} dimensions.}
\item{\code{pca.scores}: a data frame with scores (rotated observations on the new components) including
only the first \code{ncp} dimensions.}
\item{\code{plot.pca}: a scatterplot with the first two-dimensions (PC1 and PC2) and their scores.}
\item{\code{plot.scree}: a barchart with the percentage of variances explained by the \code{ncp} dimensions.}
}
}
\description{
Generates a PCA and summary statistics from a given kinship matrix for
population structure. This matrix
can be a pedigree-based relationship matrix \eqn{\boldsymbol{A}}, a genomic
relationship matrix \eqn{\boldsymbol{G}} or a hybrid relationship matrix
\eqn{\boldsymbol{H}}. Individual names should be assigned to \code{rownames} and
\code{colnames}. There is additional output such as plots and other data frames
to be used on other downstream analyses (such as GWAS).
}
\details{
It calls function \code{eigen()} to obtain eigenvalues and later generate the PCA and the
\code{factoextra} R package to extract and visualize results.
}
\examples{
# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden")$G
G[1:5, 1:5]

# Perform the PCA.
G_pca <- kinship.pca(K = G, ncp = 10)
ls(G_pca)
G_pca$eigenvalues
head(G_pca$pca.scores)
G_pca$plot.pca
G_pca$plot.scree

# PCA plot by family (17 groups).
grp <- as.factor(pheno.apple$Family)
G_pca_grp <- kinship.pca(K = G, groups = grp, label = FALSE, ellipses = FALSE)
G_pca_grp$plot.pca

}
