% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle-vcf.R
\name{import.vcf}
\alias{import.vcf}
\title{Import VCF file}
\usage{
import.vcf(vcf.path, info.fields = NULL, format.fields = NULL, verbose = FALSE)
}
\arguments{
\item{vcf.path}{A character string indicating the path to the VCF file to be imported.}

\item{info.fields}{A character vector indicating the INFO fields to be imported.}

\item{format.fields}{A character vector indicating the FORMAT fields to be imported.}

\item{verbose}{A logical indicating whether verbose output should be printed by vcfR.}
}
\value{
A list containing a tibble of VCF meta data and a tibble data.frame containing the parsed VCF data in long form.
}
\description{
A wrapper for the VCF import function in the vcfR package that formats VCF data for PGS application with \code{apply.polygenic.score()}.
}
\examples{
# Example VCF
vcf <- system.file(
    'extdata',
    'HG001_GIAB.vcf.gz',
    package = 'ApplyPolygenicScore',
    mustWork = TRUE
    );
vcf.data <- import.vcf(vcf.path = vcf);
}
