% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_client_funcs.R
\name{file_share}
\alias{file_share}
\alias{file_share.character}
\alias{file_share.file_endpoint}
\alias{print.file_share}
\alias{list_file_shares}
\alias{list_file_shares.character}
\alias{list_file_shares.file_endpoint}
\alias{create_file_share}
\alias{create_file_share.character}
\alias{create_file_share.file_share}
\alias{create_file_share.file_endpoint}
\alias{delete_file_share}
\alias{delete_file_share.character}
\alias{delete_file_share.file_share}
\alias{delete_file_share.file_endpoint}
\title{Operations on a file endpoint}
\usage{
file_share(endpoint, ...)

\method{file_share}{character}(endpoint, key = NULL, token = NULL,
  sas = NULL, api_version = getOption("azure_storage_api_version"), ...)

\method{file_share}{file_endpoint}(endpoint, name, ...)

\method{print}{file_share}(x, ...)

list_file_shares(endpoint, ...)

\method{list_file_shares}{character}(endpoint, key = NULL, token = NULL,
  sas = NULL, api_version = getOption("azure_storage_api_version"), ...)

\method{list_file_shares}{file_endpoint}(endpoint, ...)

create_file_share(endpoint, ...)

\method{create_file_share}{character}(endpoint, key = NULL, token = NULL,
  sas = NULL, api_version = getOption("azure_storage_api_version"), ...)

\method{create_file_share}{file_share}(endpoint, ...)

\method{create_file_share}{file_endpoint}(endpoint, name, ...)

delete_file_share(endpoint, ...)

\method{delete_file_share}{character}(endpoint, key = NULL, token = NULL,
  sas = NULL, api_version = getOption("azure_storage_api_version"), ...)

\method{delete_file_share}{file_share}(endpoint, ...)

\method{delete_file_share}{file_endpoint}(endpoint, name, confirm = TRUE, ...)
}
\arguments{
\item{endpoint}{Either a file endpoint object as created by \link{storage_endpoint}, or a character string giving the URL of the endpoint.}

\item{...}{Further arguments passed to lower-level functions.}

\item{key, token, sas}{If an endpoint object is not supplied, authentication credentials: either an access key, an Azure Active Directory (AAD) token, or a SAS, in that order of priority.}

\item{api_version}{If an endpoint object is not supplied, the storage API version to use when interacting with the host. Currently defaults to \code{"2019-07-07"}.}

\item{name}{The name of the file share to get, create, or delete.}

\item{x}{For the print method, a file share object.}

\item{confirm}{For deleting a share, whether to ask for confirmation.}
}
\value{
For \code{file_share} and \code{create_file_share}, an S3 object representing an existing or created share respectively.

For \code{list_file_shares}, a list of such objects.
}
\description{
Get, list, create, or delete file shares.
}
\details{
You can call these functions in a couple of ways: by passing the full URL of the share, or by passing the endpoint object and the name of the share as a string.
}
\examples{
\dontrun{

endp <- file_endpoint("https://mystorage.file.core.windows.net/", key="access_key")

# list file shares
list_file_shares(endp)

# get, create, and delete a file share
file_share(endp, "myshare")
create_file_share(endp, "newshare")
delete_file_share(endp, "newshare")

# alternative way to do the same
file_share("https://mystorage.file.file.windows.net/myshare", key="access_key")
create_file_share("https://mystorage.file.core.windows.net/newshare", key="access_key")
delete_file_share("https://mystorage.file.core.windows.net/newshare", key="access_key")

}
}
\seealso{
\link{storage_endpoint}, \link{az_storage}, \link{storage_container}
}
