% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{getTransformations}
\alias{getTransformations}
\title{Return a list with transformation functions}
\usage{
getTransformations(data, shift = FALSE, args = list(N0 = 1, time.hours
  = 1))
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{shift}{If \code{TRUE} or is a numeric value, then a two-parameter
Box-Cox transformation is assumed. This parameter will be passed on to
\code{\link{optim.boxcox}} function.}

\item{args}{List with elements that are added to the list of transformation
function and which can be used by these functions. In particular, this
list should be of type \code{args = list("N0" = 1, "time.hours" = 1)} where
\code{N0} and \code{time.hours} are arguments used for the biological
transform.}
}
\value{
This function returns a list with transformation functions. These
  include power transformation (\code{"PowerT"}) and its inverse
  (\code{"InvPowerT"}) as well as biological transformation (\code{"BiolT"})
  and its inverse (\code{"InvBiolT"}).

  Power transformation is a 1-parameter Box-Cox transformation. If
  \code{shift = TRUE}, then power transformation is a 2-parameter Box-Cox
  transformation. Optimal values for power and shift operators are selected
  by means of \code{\link{optim.boxcox}} function.

  Biological transformation \code{y = N0 * exp(x * t)} where \code{N0} is the
  initial cell count and \code{t} is the incubation time. If response/effect
  variable (\code{y}) is given in terms of cell counts, biological
  transformation ensures that modelisation is done for the growth rate
  instead (\code{x}).

  Returned list also contains \code{"compositeArgs"} elements shared by all
  the transformation functions. These arguments include initial cell count
  (\code{"N0"}) and incubation time (\code{"time.hours"}).
}
\description{
This function takes in response data from a dose-response model and attempts
to find an optimal Box-Cox power transform based on
\code{\link{optim.boxcox}} function. It then returns a list of transformation
functions which contains this power transform and its inverse which can be
subsequently used in \code{\link{fitMarginals}} and \code{\link{fitSurface}}.
}
\details{
Additionally, returned list contains biological transform and its inverse
based on a simple exponential growth model, especially useful when response
data is provided in cell counts. User can additionally provide arguments for
these biological transforms where \code{N0} stands for initial cell count and
\code{time.hours} indicates number in hours after which response data was
measured.

\code{\link{getTransformations}} relies on
  \code{\link{optim.boxcox}} to obtain the optimal Box-Cox transformation
  parameters. However, \code{\link{optim.boxcox}} optimizes for the power
  parameter only within the interval (0.1, 0.9). Hence, if obtained power
  parameter is close to 0.1, then a logarithmic transformation is applied
  instead.
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  getTransformations(data)
}
