% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateAUCandStdErr.R
\encoding{UTF-8}
\name{estimateAUCandStdErr}
\alias{estimateAUCandStdErr}
\title{Estimate AUC and its standard error}
\usage{
estimateAUCandStdErr(imputedData, timePoints, isMultiplicative = FALSE,
  na.rm = FALSE)
}
\arguments{
\item{imputedData}{numeric matrix or data frame of size 
n by J (n the sample size and J the number of time points)}

\item{timePoints}{vector of time points}

\item{isMultiplicative}{logical variable indicating whether
an additive error model (FALSE) or a multiplicative error
model (TRUE) should be used}

\item{na.rm}{logical variable indicating whether the rows with
missing values should be ignored or not.}
}
\value{
vector of length 2 with estimated AUC and its 
standard error
}
\description{
function to estimate AUC and compute standard error of this
estimate
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
 		1, 1, seq(0.5,3,0.5))
# Impute the data with BLOQ's with one of the provided methods,
# for example, here we use ROS
imputedDataROS <- imputeROS(genDataFixedEffects, 0.1)
# estimate AUC and its standard error
estimateAUCandStdErr(imputedDataROS,seq(0.5,3,0.5))

}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
