% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_More.R
\name{BT_more}
\alias{BT_more}
\title{Perform additional boosting iterations.}
\usage{
BT_more(BTFit_object, new.n.iter = 100, is.verbose = FALSE, seed = NULL)
}
\arguments{
\item{BTFit_object}{a \code{\link{BTFit}} object.}

\item{new.n.iter}{number of new boosting iterations to perform.}

\item{is.verbose}{a logical specifying whether or not the additional fitting should run "noisely" with feedback on progress provided to the user.}

\item{seed}{optional seed used to perform the new iterations. By default, no seed is set.}
}
\value{
Returns a new \code{\link{BTFit}} object containing the initial call as well as the new iterations performed.
}
\description{
Method to perform additional iterations of the Boosting Tree algorithm, starting from an initial \code{\link{BTFit}} object.
This does not support further cross-validation. Moreover, this approach is only allowed if \code{keep.data=TRUE} in the original call.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}, \code{\link{BTFit}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
