% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcRocPrc.R
\name{compute_roc}
\alias{compute_roc}
\alias{compute_pr}
\title{Compute ROC and PR curve points}
\usage{
compute_roc(yvec, pvec)

compute_pr(yvec, pvec)
}
\description{
Faster replacements for calculating ROC and PR curve data than with
\code{\link[ROCR:prediction]{ROCR::prediction()}} and \code{\link[ROCR:performance]{ROCR::performance()}}
}
\details{
Replacements to use instead of a combination of \code{\link[ROCR:prediction]{ROCR::prediction()}}
and \code{\link[ROCR:performance]{ROCR::performance()}} to calculate ROC and PR curves. These functions are
about 10 to 20 times faster when using \code{\link[=mcmcRocPrc]{mcmcRocPrc()}} with \code{curves = TRUE}
and/or \code{fullsims = TRUE}.

See this \href{https://github.com/ShanaScogin/BayesPostEst/issues/25}{issue on GH (ShanaScogin/BayesPostEst#25)} for more general details.

And \href{https://github.com/andybega/BayesPostEst/blob/f1da23b9db86461d4f9c671d9393265dd10578c5/tests/profile-mcmcRocPrc.md}{here is a note} with specific performance benchmarks, compared to the
old approach relying on ROCR.
}
\keyword{internal}
