/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.ExpandAlignmentStateSpace;
import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evoxml.util.DataTypeUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class ExpandAlignmentStateSpaceParser
extends AbstractXMLObjectParser {
    public static final String EXPAND = "expandStateSpace";
    public static final String TRAIT = "trait";
    public static final String ALIGNMENT = "alignment";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("alignment", Alignment.class), new ElementRule("trait", PatternList.class)};

    @Override
    public String getParserName() {
        return EXPAND;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        Alignment alignment = (Alignment)xMLObject.getElementFirstChild(ALIGNMENT);
        PatternList patternList = (PatternList)xMLObject.getElementFirstChild(TRAIT);
        ExpandAlignmentStateSpace expandAlignmentStateSpace = new ExpandAlignmentStateSpace(dataType, alignment, patternList);
        Logger.getLogger("dr.evoxml").info("Converted alignment, '" + xMLObject.getId() + "', from " + alignment.getDataType().getDescription() + " to " + dataType.getDescription());
        return expandAlignmentStateSpace;
    }

    @Override
    public String getParserDescription() {
        return "Converts an alignment to the given data type.";
    }

    @Override
    public Class getReturnType() {
        return Alignment.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

