/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.math.distributions.PointMassMixtureDistribution;

public class PointMassMixtureDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel {
    private Parameter weights;
    private CompoundParameter realizedParameters;
    private boolean weightsNormalized;
    private int dim;

    public PointMassMixtureDistributionModel(Parameter parameter, CompoundParameter compoundParameter, boolean bl) {
        super("pointMassMixtureDistributionModel");
        this.weights = parameter;
        this.addVariable(this.weights);
        this.realizedParameters = compoundParameter;
        this.addVariable(this.realizedParameters);
        this.weightsNormalized = bl;
        this.dim = compoundParameter.getParameter(0).getDimension();
    }

    @Override
    public double logPdf(double[] dArray) {
        return PointMassMixtureDistribution.logPdf(dArray, this.getProbabilities(), this.getRealizedValues());
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("getScaleMatrix should not get called");
    }

    @Override
    public double[] getMean() {
        return PointMassMixtureDistribution.getMean(this.getProbabilities(), this.getRealizedValues());
    }

    @Override
    public String getType() {
        return "PointMassMixture";
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Variable<Double> getLocationVariable() {
        double[] dArray = PointMassMixtureDistribution.getMean(this.getProbabilities(), this.getRealizedValues());
        Parameter.Default default_ = new Parameter.Default(dArray.length);
        for (int i = 0; i < default_.getSize(); ++i) {
            default_.setParameterValue(i, dArray[i]);
        }
        return default_;
    }

    public double[] getProbabilities() {
        int n;
        if (this.weightsNormalized) {
            return this.weights.getParameterValues();
        }
        double[] dArray = this.weights.getParameterValues();
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = dArray[n] / d;
        }
        return dArray;
    }

    private double[][] getRealizedValues() {
        int n = this.realizedParameters.getParameter(0).getSize();
        int n2 = this.weights.getSize();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.realizedParameters.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    private double[] getWeights() {
        return this.weights.getParameterValues();
    }

    @Override
    public double[] nextRandom() {
        int n = MathUtils.randomChoicePDF(this.getProbabilities());
        return this.realizedParameters.getParameter(n).getParameterValues();
    }

    public double logPdf(Object object) {
        double[] dArray = (double[])object;
        return PointMassMixtureDistribution.logPdf(dArray, this.getProbabilities(), this.getRealizedValues());
    }

    @Override
    public int getDimension() {
        return this.dim;
    }
}

